/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.builder.api.Api;
import com.para.secure.builder.api.OAuthApi20;
import com.para.secure.utils.OAuthConfigUtil;
import com.para.secure.utils.Preconditions;

public class OAuthApiBuilderFromConfig {
    private static OAuthApiBuilderFromConfig model;
    private static Api api;

    private OAuthApiBuilderFromConfig() {
    }

    public static OAuthApiBuilderFromConfig getInstance() {
        if (model == null) {
            model = new OAuthApiBuilderFromConfig();
            api = OAuthApiBuilderFromConfig.createOAuthApi();
        }
        return model;
    }

    public Api getApi() {
        return api;
    }

    private static Api createOAuthApi() {
        String authorizeUrl = OAuthConfigUtil.getValue("authorize_url");
        String accessTokenUrl = OAuthConfigUtil.getValue("accessToken_url");
        Preconditions.checkEmptyString(authorizeUrl, "Invalid OAuth authorize_url");
        Preconditions.checkEmptyString(accessTokenUrl, "Invalid OAuth accessToken_url");
        return new OAuthApi20(authorizeUrl, accessTokenUrl);
    }
}

