/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.model.OAuthConfig;
import com.para.secure.model.SignatureType;
import com.para.secure.utils.Preconditions;

public class OAuthConfigBuilder {
    private String apiKey;
    private String apiSecret;
    private String callback;
    private String scope;

    public OAuthConfigBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid OAuth apiKey");
        this.apiKey = apiKey;
        return this;
    }

    public OAuthConfigBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid OAuth apiSecret");
        this.apiSecret = apiSecret;
        return this;
    }

    public OAuthConfigBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuthConfigBuilder callback(String callback) {
        Preconditions.checkEmptyString(callback, "Invalid OAuth callback");
        this.callback = callback;
        return this;
    }

    public OAuthConfig buildConfig() {
        Preconditions.checkEmptyString(this.apiKey, "Invalid OAuth apiKey");
        Preconditions.checkEmptyString(this.apiKey, "Invalid OAuth apiSecret");
        Preconditions.checkEmptyString(this.apiKey, "Invalid OAuth callback");
        return new OAuthConfig(this.apiKey, this.apiSecret, this.callback, SignatureType.Header, this.scope, null);
    }
}

