/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.builder.OAuthApiBuilderFromConfig;
import com.para.secure.builder.OAuthConfigBuilderFromConfig;
import com.para.secure.builder.api.Api;
import com.para.secure.builder.api.DefaultApi20;
import com.para.secure.exceptions.OAuthException;
import com.para.secure.model.OAuthConfig;
import com.para.secure.oauth.IOAuth20Service;
import com.para.secure.utils.Preconditions;

public class OAuthServiceBuilderFromConfig {
    public static IOAuth20Service build20Service() {
        OAuthConfig config = OAuthConfigBuilderFromConfig.getInstance().getoAuthConfig();
        Api api = OAuthApiBuilderFromConfig.getInstance().getApi();
        Preconditions.checkNotNull(config, "OAuthConfig cannot be null");
        Preconditions.checkNotNull(api, "Api cannot be null");
        if (!(api instanceof DefaultApi20)) {
            throw new OAuthException("Api Validate");
        }
        return (IOAuth20Service)api.createService(config);
    }
}

