/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder.api;

import com.para.secure.builder.api.Api;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.extractors.BaseStringExtractor;
import com.para.secure.extractors.BaseStringExtractorImpl;
import com.para.secure.extractors.HeaderExtractor;
import com.para.secure.extractors.HeaderExtractorImpl;
import com.para.secure.extractors.RequestTokenExtractor;
import com.para.secure.extractors.TokenExtractorImpl;
import com.para.secure.model.OAuthConfig;
import com.para.secure.model.Token;
import com.para.secure.model.Verb;
import com.para.secure.oauth.IOAuthService;
import com.para.secure.oauth.OAuth10aServiceImpl;
import com.para.secure.services.HMACSha1SignatureService;
import com.para.secure.services.SignatureService;
import com.para.secure.services.TimestampService;
import com.para.secure.services.TimestampServiceImpl;

public abstract class DefaultApi10a
implements Api {
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    public HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    public RequestTokenExtractor getRequestTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    public TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public Verb getRequestTokenVerb() {
        return Verb.POST;
    }

    public abstract String getRequestTokenEndpoint();

    public abstract String getAccessTokenEndpoint();

    public abstract String getAuthorizationUrl(Token var1);

    @Override
    public IOAuthService createService(OAuthConfig config) {
        return new OAuth10aServiceImpl(this, config);
    }
}

