/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.client;

import com.para.secure.model.OAuthRequest;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.model.Verb;
import com.para.secure.utils.Preconditions;

public class OAuthClient {
    private Verb method = Verb.GET;
    private OAuthRequest request;

    public OAuthClient(String url) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        this.request = new OAuthRequest(this.method, url);
    }

    public OAuthClient(Verb method, String url) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        if (method != null) {
            this.method = method;
        }
        this.request = new OAuthRequest(method, url);
    }

    public void signAccessToken(Token accessToken) {
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    public void addParameter(String name, String value) {
        Preconditions.checkEmptyString(name, "parameter name is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        if (Verb.GET == this.method) {
            this.request.addQuerystringParameter(name, value);
        } else if (Verb.POST == this.method) {
            this.request.addBodyParameter(name, value);
        }
    }

    public Response execute() {
        return this.request.send();
    }
}

