/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.client.model;

import com.para.secure.client.BaseEntity;
import com.para.secure.client.OAuthClient;
import com.para.secure.exceptions.OAuthApiException;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.utils.Json2ObjectUtil;
import com.para.secure.utils.OAuthConfigUtil;
import com.para.secure.utils.Preconditions;
import java.util.HashMap;

public class UserInfo
extends BaseEntity {
    private String id;
    private String linkId;
    private Token accessToken;

    public UserInfo() {
    }

    public UserInfo(Token accessToken) {
        this.accessToken = accessToken;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String requestUserInfo(String userInfoUrl) throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        if ("".equals(userInfoUrl) || userInfoUrl == null) {
            throw new OAuthApiException("urlnull", "\u83b7\u53d6\u7528\u6237\u4fe1\u606fURL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OAuthClient client = new OAuthClient(userInfoUrl);
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        HashMap user = new HashMap();
        System.out.println("response.getBody()>>>" + response.getBody());
        return response.getBody();
    }

    public String requestJsonUserInfo() throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        OAuthClient client = new OAuthClient(OAuthConfigUtil.getUserInfoUrl());
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        UserInfo user = new UserInfo();
        System.out.println("response.getBody()>>>" + response.getBody());
        if (user.getError() != null && !"".equals(user.getError().trim())) {
            throw new OAuthApiException(user.getError(), user.getError_description());
        }
        return response.getBody();
    }

    public UserInfo getUserInfo() throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        OAuthClient client = new OAuthClient(OAuthConfigUtil.getUserInfoUrl());
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        HashMap userMap = new HashMap();
        UserInfo user = new UserInfo();
        System.out.println("response.getBody()>>>" + response.getBody());
        if (response.getBody() != null && !"".equals(response.getBody().trim())) {
            userMap = (HashMap)Json2ObjectUtil.json2Object(response.getBody(), userMap);
            user.setId(userMap.get("id").toString());
            user.setLinkId(userMap.get("attributes").toString());
        }
        return user;
    }

    public String toString() {
        return "UserInfo [id=" + this.id + ", linkId=" + this.linkId + "]";
    }
}

