/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.extractors;

import com.para.secure.exceptions.OAuthException;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.model.Token;
import com.para.secure.utils.OAuthEncoder;
import com.para.secure.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractor20Impl
implements AccessTokenExtractor {
    private static final String TOKEN_REGEX = "access_token=([^&]+)";
    private static final String EMPTY_SECRET = "";

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.find()) {
            String token = OAuthEncoder.decode(matcher.group(1));
            return new Token(token, EMPTY_SECRET, response);
        }
        throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
    }

    @Override
    public Token extractESCToken(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.find()) {
            String token = OAuthEncoder.decode(matcher.group(1));
            return new Token(token, EMPTY_SECRET, response);
        }
        throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
    }
}

