/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.oauth;

import com.para.secure.builder.api.DefaultApi10a;
import com.para.secure.model.OAuthConfig;
import com.para.secure.model.OAuthRequest;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.model.Verifier;
import com.para.secure.oauth.IOAuth10Service;
import com.para.secure.utils.MapUtils;
import com.para.secure.utils.OAuthConstants;
import java.util.Map;

public class OAuth10aServiceImpl
implements IOAuth10Service {
    private static final String VERSION = "1.0";
    private OAuthConfig config;
    private DefaultApi10a api;

    public OAuth10aServiceImpl(DefaultApi10a api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    @Override
    public Token getRequestToken() {
        this.config.log("obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        this.config.log("setting oauth_callback to " + this.config.getCallback());
        request.addOAuthParameter("oauth_callback", this.config.getCallback());
        this.addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        this.appendSignature(request);
        this.config.log("sending request...");
        Response response = request.send();
        String body = response.getBody();
        this.config.log("response status code: " + response.getCode());
        this.config.log("response body: " + body);
        return this.api.getRequestTokenExtractor().extract(body);
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        if (this.config.hasScope()) {
            request.addOAuthParameter("scope", this.config.getScope());
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
        this.config.log("appended additional OAuth parameters: " + MapUtils.toString(request.getOauthParameters()));
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        this.config.log("obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", verifier.getValue());
        this.config.log("setting token to: " + requestToken + " and verifier to: " + verifier);
        this.addOAuthParams(request, requestToken);
        this.appendSignature(request);
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    public void signAccessTokenRequest(Token token, OAuthRequest request) {
        this.config.log("signing request: " + request.getCompleteUrl());
        request.addOAuthParameter("oauth_token", token.getToken());
        this.config.log("setting token to: " + token);
        this.addOAuthParams(request, token);
        this.appendSignature(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, Token token) {
        this.config.log("generating signature...");
        String baseString = this.api.getBaseStringExtractor().extract(request);
        String signature = this.api.getSignatureService().getSignature(baseString, this.config.getApiSecret(), token.getSecret());
        this.config.log("base string is: " + baseString);
        this.config.log("signature is: " + signature);
        return signature;
    }

    private void appendSignature(OAuthRequest request) {
        switch (this.config.getSignatureType()) {
            case Header: {
                this.config.log("using Http Header signature");
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QueryString: {
                this.config.log("using Querystring signature");
                for (Map.Entry<String, String> entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                break;
            }
        }
    }
}

