/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.oauth;

import com.para.secure.builder.api.DefaultApi20;
import com.para.secure.model.OAuthConfig;
import com.para.secure.model.OAuthRequest;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.oauth.IOAuth20Service;

public class OAuth20ServiceImpl
implements IOAuth20Service {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;
    private final OAuthConfig config;

    public OAuth20ServiceImpl(DefaultApi20 api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.api.getAuthorizationUrl(this.config);
    }

    @Override
    public Response getAccessTokenResponse(String code) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addQuerystringParameter("client_id", this.config.getApiKey());
        request.addQuerystringParameter("client_secret", this.config.getApiSecret());
        request.addQuerystringParameter("code", code);
        request.addQuerystringParameter("redirect_uri", this.config.getCallback());
        if (this.config.hasScope()) {
            request.addQuerystringParameter("scope", this.config.getScope());
        }
        return request.send();
    }

    @Override
    public Token getAccessToken(String code) {
        Response response = this.getAccessTokenResponse(code);
        return this.extractAccessTokenResponse(response);
    }

    @Override
    public Response getRefreshTokenResponse(String refreshToken) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint());
        request.addQuerystringParameter("client_id", this.config.getApiKey());
        request.addQuerystringParameter("client_secret", this.config.getApiSecret());
        request.addQuerystringParameter("refresh_token", refreshToken);
        if (this.config.hasScope()) {
            request.addQuerystringParameter("scope", this.config.getScope());
        }
        return request.send();
    }

    @Override
    public Token getRefreshToken(String refreshToken) {
        Response response = this.getRefreshTokenResponse(refreshToken);
        return this.extractTokenResponse(response);
    }

    @Override
    public Token extractAccessTokenResponse(Response response) {
        if (response.getBody() != null && !"".equals(response.getBody())) {
            return this.api.getAccessTokenExtractor().extractESCToken(response.getBody());
        }
        return null;
    }

    @Override
    public Token extractTokenResponse(Response response) {
        if (response.getBody() != null && !"".equals(response.getBody())) {
            return this.api.getAccessTokenExtractor().extract(response.getBody());
        }
        return null;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signAccessTokenRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }
}

