/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.oauth;

import com.para.secure.builder.api.OAuthPasswordApi20;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.OAuthRequest;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.model.Verb;

public class OAuthPasswordService {
    private OAuth20Config config;
    private OAuthPasswordApi20 passwordApi20;

    public OAuthPasswordService() {
    }

    public OAuthPasswordService(OAuth20Config config, OAuthPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
        this.config = config;
    }

    public Token getAccessToken(String username, String password) {
        try {
            String accessTokenUrl = this.passwordApi20.getAuthorizationUrl(this.config, username, password);
            System.out.println(accessTokenUrl);
            OAuthRequest oauthRequest = new OAuthRequest(Verb.GET, accessTokenUrl);
            Response response = oauthRequest.send();
            return this.passwordApi20.getAccessTokenExtractor().extract(response.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OAuth20Config getConfig() {
        return this.config;
    }

    public void setConfig(OAuth20Config config) {
        this.config = config;
    }

    public OAuthPasswordApi20 getPasswordApi20() {
        return this.passwordApi20;
    }

    public void setPasswordApi20(OAuthPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
    }
}

