/*
 * Decompiled with CFR 0.152.
 */
package com.cntp;

import com.cntp.RandomGUID;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationTools {
    protected static final String X509 = "X.509";
    protected static final int MAX_ENCRYPT_BLOCK = 117;
    protected static final int MAX_DECRYPT_BLOCK = 128;
    protected static final String APP_SESSION_ID = "ssoRequestId";
    protected static final String REQUESTID = "requestId";
    protected static final String RESPONSETOKEN = "requestToken";
    protected static final String RESPONSEKEY = "responseToken";
    protected static final String TOKEN_SERVER_CERT_PATH = "tokenServerCertPath";
    protected static final String APP_KEYSTORE_PATH = "appKeyStorePath";
    protected static final String APP_KEYSTORE_ALIAS = "appKeyStoreAlias";
    protected static final String APP_KEYSTORE_ALIAS_PWD = "appKeyStoreAliasPwd";
    protected static final String KEYSTORE_TYPE = "keyStoreType";

    protected static boolean decryptSign(byte[] encryptSineData, byte[] encryptKeyData, String certificatePath) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)AuthenticationTools.getCertificate(certificatePath);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(encryptKeyData);
        return signature.verify(encryptSineData);
    }

    protected static byte[] decryptByKey(byte[] encryptedData, String keyStorePath, String alias, String password, String keyType) throws Exception {
        PrivateKey privateKey = AuthenticationTools.getPrivateKey(keyStorePath, alias, password, keyType);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    protected static byte[] decodeBase64(String binaryData) throws Base64DecodingException {
        return Base64.decode(binaryData);
    }

    protected static byte[] decryptByPublicKey(byte[] cookieData, String certificatePath) throws Exception {
        PublicKey publicKey = AuthenticationTools.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, publicKey);
        int inputLen = cookieData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(cookieData, offSet, 128) : cipher.doFinal(cookieData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    protected static byte[] encryptByKey(String requestStr, String certificatePath) throws Exception {
        byte[] data = requestStr.getBytes();
        PublicKey publicKey = AuthenticationTools.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    protected static byte[] encryptSign(byte[] binaryData, String keyStorePath, String alias, String aliasPassword, String keyType) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)AuthenticationTools.getCertificate(keyStorePath, alias, aliasPassword, keyType);
        KeyStore keyStore = AuthenticationTools.getKeyStore(keyStorePath, aliasPassword, keyType);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, aliasPassword.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        signature.update(binaryData);
        return signature.sign();
    }

    protected static String encodeBase64(byte[] binaryData) throws Exception {
        return Base64.encode(binaryData);
    }

    protected static byte[] encryptByPrivateKey(String cookieData, String keyStorePath, String alias, String password, String keyType) throws Exception {
        byte[] cookieDataByte = cookieData.getBytes();
        PrivateKey privateKey = AuthenticationTools.getPrivateKey(keyStorePath, alias, password, keyType);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        int inputLen = cookieDataByte.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(cookieDataByte, offSet, 117) : cipher.doFinal(cookieDataByte, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    protected static PublicKey getPublicKey(String certificatePath) throws Exception {
        Certificate certificate = AuthenticationTools.getCertificate(certificatePath);
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    protected static Certificate getCertificate(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    protected static PrivateKey getPrivateKey(String keyStorePath, String alias, String password, String keyType) throws Exception {
        KeyStore keyStore = AuthenticationTools.getKeyStore(keyStorePath, password, keyType);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return privateKey;
    }

    protected static KeyStore getKeyStore(String keyStorePath, String password, String keyType) throws Exception {
        FileInputStream in = new FileInputStream(keyStorePath);
        KeyStore keyStore = KeyStore.getInstance(keyType);
        keyStore.load(in, password.toCharArray());
        in.close();
        return keyStore;
    }

    protected static Certificate getCertificate(String keyStorePath, String alias, String password, String keyType) throws Exception {
        KeyStore keyStore = AuthenticationTools.getKeyStore(keyStorePath, password, keyType);
        Certificate certificate = keyStore.getCertificate(alias);
        return certificate;
    }

    public String encryptData(JSONObject json, String tokenServerCertPath, String appKeyStorePath, String appKeyStoreAlias, String appKeyStoreAliasPwd, String keyStoreType) {
        String result = "";
        try {
            byte[] byKey = AuthenticationTools.encryptByKey(json.toString(), tokenServerCertPath);
            byte[] bySign = AuthenticationTools.encryptSign(byKey, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
            String encodeSignResult = AuthenticationTools.encodeBase64(bySign);
            String encodeKeyResult = AuthenticationTools.encodeBase64(byKey);
            result = String.valueOf(encodeKeyResult) + "@" + encodeSignResult;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public JSONObject decryptData(String encodedData, String tokenServerCertPath, String appKeyStorePath, String appKeyStoreAlias, String appKeyStoreAliasPwd, String keyStoreType) {
        JSONObject json = null;
        String result = "";
        try {
            byte[] encodeKeyResult = AuthenticationTools.decodeBase64(encodedData.split("@")[0]);
            byte[] encodeSignResult = AuthenticationTools.decodeBase64(encodedData.split("@")[1]);
            boolean decodeKeyResult = AuthenticationTools.decryptSign(encodeSignResult, encodeKeyResult, tokenServerCertPath);
            if (decodeKeyResult) {
                byte[] decodeResult = AuthenticationTools.decryptByKey(encodeKeyResult, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
                result = new String(decodeResult);
            }
            json = new JSONObject(result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return json;
    }

    public String encryptCookie(JSONObject json, String appKeyStorePath, String appKeyStoreAlias, String appKeyStoreAliasPwd, String keyStoreType) {
        String result = "";
        try {
            byte[] byKey = AuthenticationTools.encryptByPrivateKey(json.toString(), appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
            byte[] bySign = AuthenticationTools.encryptSign(byKey, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
            String encodeSignResult = AuthenticationTools.encodeBase64(bySign);
            String encodeKeyResult = AuthenticationTools.encodeBase64(byKey);
            result = String.valueOf(encodeKeyResult) + "@" + encodeSignResult;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public JSONObject cookieAcquisition(String encodeCookieData, String tokenServerCertPath) {
        JSONObject json = new JSONObject();
        String result = "";
        if (encodeCookieData == null || "".equals(encodeCookieData)) {
            return null;
        }
        try {
            json.put("CNTPAuth", (Object)"CNTPAuth");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public void ssoAuth(JSONObject json, Map certMap, HttpServletRequest request, HttpServletResponse response, String ssoUrl) {
        RandomGUID rguid = new RandomGUID();
        try {
            String requestId = rguid.valueAfterMD5;
            request.getSession().setAttribute(APP_SESSION_ID, (Object)requestId);
            json.put(REQUESTID, (Object)requestId);
            String tokenServerCertPath = certMap.get(TOKEN_SERVER_CERT_PATH).toString();
            String appKeyStorePath = certMap.get(APP_KEYSTORE_PATH).toString();
            String appKeyStoreAlias = certMap.get(APP_KEYSTORE_ALIAS).toString();
            String appKeyStoreAliasPwd = certMap.get(APP_KEYSTORE_ALIAS_PWD).toString();
            String keyStoreType = certMap.get(KEYSTORE_TYPE).toString();
            String encode = this.encryptData(json, tokenServerCertPath, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
            response.sendRedirect(String.valueOf(ssoUrl) + "?" + RESPONSETOKEN + "=" + URLEncoder.encode(encode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject userAcquisition(HttpServletRequest request, Map certMap) {
        String requestId;
        JSONObject json;
        block7: {
            block6: {
                if (request.getParameter(RESPONSEKEY) == null || "".equals(request.getParameter(RESPONSEKEY))) {
                    return null;
                }
                String tokenServerCertPath = certMap.get(TOKEN_SERVER_CERT_PATH).toString();
                String appKeyStorePath = certMap.get(APP_KEYSTORE_PATH).toString();
                String appKeyStoreAlias = certMap.get(APP_KEYSTORE_ALIAS).toString();
                String appKeyStoreAliasPwd = certMap.get(APP_KEYSTORE_ALIAS_PWD).toString();
                String keyStoreType = certMap.get(KEYSTORE_TYPE).toString();
                String encodeData = request.getParameter(RESPONSEKEY);
                json = this.decryptData(encodeData, tokenServerCertPath, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
                try {
                    if (json != null) break block6;
                    return null;
                }
                catch (JSONException e) {
                    return null;
                }
            }
            requestId = json.getString(REQUESTID);
            if (request.getSession().getAttribute(APP_SESSION_ID) != null && !"".equals(request.getSession().getAttribute(APP_SESSION_ID))) break block7;
            return null;
        }
        String appRequestId = request.getSession().getAttribute(APP_SESSION_ID).toString();
        if (requestId == appRequestId || appRequestId.equals(appRequestId)) {
            json.remove(REQUESTID);
            return json;
        }
        return null;
    }

    public void ssoDistory(JSONObject json, Map certMap, HttpServletRequest request, HttpServletResponse response, String ssoUrl) {
        try {
            String tokenServerCertPath = certMap.get(TOKEN_SERVER_CERT_PATH).toString();
            String appKeyStorePath = certMap.get(APP_KEYSTORE_PATH).toString();
            String appKeyStoreAlias = certMap.get(APP_KEYSTORE_ALIAS).toString();
            String appKeyStoreAliasPwd = certMap.get(APP_KEYSTORE_ALIAS_PWD).toString();
            String keyStoreType = certMap.get(KEYSTORE_TYPE).toString();
            String encode = this.encryptData(json, tokenServerCertPath, appKeyStorePath, appKeyStoreAlias, appKeyStoreAliasPwd, keyStoreType);
            response.sendRedirect(String.valueOf(ssoUrl) + "?" + RESPONSETOKEN + "=" + URLEncoder.encode(encode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

