/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatafeedRunningState
implements JsonpSerializable {
    private final boolean realTimeConfigured;
    private final boolean realTimeRunning;
    public static final JsonpDeserializer<DatafeedRunningState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedRunningState::setupDatafeedRunningStateDeserializer);

    private DatafeedRunningState(Builder builder) {
        this.realTimeConfigured = ApiTypeHelper.requireNonNull(builder.realTimeConfigured, this, "realTimeConfigured");
        this.realTimeRunning = ApiTypeHelper.requireNonNull(builder.realTimeRunning, this, "realTimeRunning");
    }

    public static DatafeedRunningState of(Function<Builder, ObjectBuilder<DatafeedRunningState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean realTimeConfigured() {
        return this.realTimeConfigured;
    }

    public final boolean realTimeRunning() {
        return this.realTimeRunning;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("real_time_configured");
        generator.write(this.realTimeConfigured);
        generator.writeKey("real_time_running");
        generator.write(this.realTimeRunning);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDatafeedRunningStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::realTimeConfigured, JsonpDeserializer.booleanDeserializer(), "real_time_configured");
        op.add(Builder::realTimeRunning, JsonpDeserializer.booleanDeserializer(), "real_time_running");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatafeedRunningState> {
        private Boolean realTimeConfigured;
        private Boolean realTimeRunning;

        public final Builder realTimeConfigured(boolean value) {
            this.realTimeConfigured = value;
            return this;
        }

        public final Builder realTimeRunning(boolean value) {
            this.realTimeRunning = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatafeedRunningState build() {
            this._checkSingleUse();
            return new DatafeedRunningState(this);
        }
    }
}

