/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.pending_tasks.PendingTask;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PendingTasksResponse
implements JsonpSerializable {
    private final List<PendingTask> tasks;
    public static final JsonpDeserializer<PendingTasksResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTasksResponse::setupPendingTasksResponseDeserializer);

    private PendingTasksResponse(Builder builder) {
        this.tasks = ApiTypeHelper.unmodifiableRequired(builder.tasks, (Object)this, "tasks");
    }

    public static PendingTasksResponse of(Function<Builder, ObjectBuilder<PendingTasksResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<PendingTask> tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.tasks)) {
            generator.writeKey("tasks");
            generator.writeStartArray();
            for (PendingTask item0 : this.tasks) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPendingTasksResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tasks, JsonpDeserializer.arrayDeserializer(PendingTask._DESERIALIZER), "tasks");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PendingTasksResponse> {
        private List<PendingTask> tasks;

        public final Builder tasks(List<PendingTask> list) {
            this.tasks = Builder._listAddAll(this.tasks, list);
            return this;
        }

        public final Builder tasks(PendingTask value, PendingTask ... values) {
            this.tasks = Builder._listAdd(this.tasks, value, values);
            return this;
        }

        public final Builder tasks(Function<PendingTask.Builder, ObjectBuilder<PendingTask>> fn) {
            return this.tasks(fn.apply(new PendingTask.Builder()).build(), new PendingTask[0]);
        }

        @Override
        public PendingTasksResponse build() {
            this._checkSingleUse();
            return new PendingTasksResponse(this);
        }
    }
}

