/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.CompletionStats;
import co.elastic.clients.elasticsearch._types.DocStats;
import co.elastic.clients.elasticsearch._types.FielddataStats;
import co.elastic.clients.elasticsearch._types.QueryCacheStats;
import co.elastic.clients.elasticsearch._types.SegmentsStats;
import co.elastic.clients.elasticsearch._types.StoreStats;
import co.elastic.clients.elasticsearch.cluster.stats.CharFilterTypes;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIndicesShards;
import co.elastic.clients.elasticsearch.cluster.stats.FieldTypesMappings;
import co.elastic.clients.elasticsearch.cluster.stats.IndicesVersions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterIndices
implements JsonpSerializable {
    private final CompletionStats completion;
    private final long count;
    private final DocStats docs;
    private final FielddataStats fielddata;
    private final QueryCacheStats queryCache;
    private final SegmentsStats segments;
    private final ClusterIndicesShards shards;
    private final StoreStats store;
    private final FieldTypesMappings mappings;
    private final CharFilterTypes analysis;
    private final List<IndicesVersions> versions;
    public static final JsonpDeserializer<ClusterIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterIndices::setupClusterIndicesDeserializer);

    private ClusterIndices(Builder builder) {
        this.completion = ApiTypeHelper.requireNonNull(builder.completion, this, "completion");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.docs = ApiTypeHelper.requireNonNull(builder.docs, this, "docs");
        this.fielddata = ApiTypeHelper.requireNonNull(builder.fielddata, this, "fielddata");
        this.queryCache = ApiTypeHelper.requireNonNull(builder.queryCache, this, "queryCache");
        this.segments = ApiTypeHelper.requireNonNull(builder.segments, this, "segments");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.store = ApiTypeHelper.requireNonNull(builder.store, this, "store");
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
        this.analysis = ApiTypeHelper.requireNonNull(builder.analysis, this, "analysis");
        this.versions = ApiTypeHelper.unmodifiable(builder.versions);
    }

    public static ClusterIndices of(Function<Builder, ObjectBuilder<ClusterIndices>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final CompletionStats completion() {
        return this.completion;
    }

    public final long count() {
        return this.count;
    }

    public final DocStats docs() {
        return this.docs;
    }

    public final FielddataStats fielddata() {
        return this.fielddata;
    }

    public final QueryCacheStats queryCache() {
        return this.queryCache;
    }

    public final SegmentsStats segments() {
        return this.segments;
    }

    public final ClusterIndicesShards shards() {
        return this.shards;
    }

    public final StoreStats store() {
        return this.store;
    }

    public final FieldTypesMappings mappings() {
        return this.mappings;
    }

    public final CharFilterTypes analysis() {
        return this.analysis;
    }

    public final List<IndicesVersions> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("completion");
        this.completion.serialize(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("docs");
        this.docs.serialize(generator, mapper);
        generator.writeKey("fielddata");
        this.fielddata.serialize(generator, mapper);
        generator.writeKey("query_cache");
        this.queryCache.serialize(generator, mapper);
        generator.writeKey("segments");
        this.segments.serialize(generator, mapper);
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("store");
        this.store.serialize(generator, mapper);
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (IndicesVersions item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterIndicesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::completion, CompletionStats._DESERIALIZER, "completion");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::docs, DocStats._DESERIALIZER, "docs");
        op.add(Builder::fielddata, FielddataStats._DESERIALIZER, "fielddata");
        op.add(Builder::queryCache, QueryCacheStats._DESERIALIZER, "query_cache");
        op.add(Builder::segments, SegmentsStats._DESERIALIZER, "segments");
        op.add(Builder::shards, ClusterIndicesShards._DESERIALIZER, "shards");
        op.add(Builder::store, StoreStats._DESERIALIZER, "store");
        op.add(Builder::mappings, FieldTypesMappings._DESERIALIZER, "mappings");
        op.add(Builder::analysis, CharFilterTypes._DESERIALIZER, "analysis");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(IndicesVersions._DESERIALIZER), "versions");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterIndices> {
        private CompletionStats completion;
        private Long count;
        private DocStats docs;
        private FielddataStats fielddata;
        private QueryCacheStats queryCache;
        private SegmentsStats segments;
        private ClusterIndicesShards shards;
        private StoreStats store;
        private FieldTypesMappings mappings;
        private CharFilterTypes analysis;
        @Nullable
        private List<IndicesVersions> versions;

        public final Builder completion(CompletionStats value) {
            this.completion = value;
            return this;
        }

        public final Builder completion(Function<CompletionStats.Builder, ObjectBuilder<CompletionStats>> fn) {
            return this.completion(fn.apply(new CompletionStats.Builder()).build());
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder docs(DocStats value) {
            this.docs = value;
            return this;
        }

        public final Builder docs(Function<DocStats.Builder, ObjectBuilder<DocStats>> fn) {
            return this.docs(fn.apply(new DocStats.Builder()).build());
        }

        public final Builder fielddata(FielddataStats value) {
            this.fielddata = value;
            return this;
        }

        public final Builder fielddata(Function<FielddataStats.Builder, ObjectBuilder<FielddataStats>> fn) {
            return this.fielddata(fn.apply(new FielddataStats.Builder()).build());
        }

        public final Builder queryCache(QueryCacheStats value) {
            this.queryCache = value;
            return this;
        }

        public final Builder queryCache(Function<QueryCacheStats.Builder, ObjectBuilder<QueryCacheStats>> fn) {
            return this.queryCache(fn.apply(new QueryCacheStats.Builder()).build());
        }

        public final Builder segments(SegmentsStats value) {
            this.segments = value;
            return this;
        }

        public final Builder segments(Function<SegmentsStats.Builder, ObjectBuilder<SegmentsStats>> fn) {
            return this.segments(fn.apply(new SegmentsStats.Builder()).build());
        }

        public final Builder shards(ClusterIndicesShards value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ClusterIndicesShards.Builder, ObjectBuilder<ClusterIndicesShards>> fn) {
            return this.shards(fn.apply(new ClusterIndicesShards.Builder()).build());
        }

        public final Builder store(StoreStats value) {
            this.store = value;
            return this;
        }

        public final Builder store(Function<StoreStats.Builder, ObjectBuilder<StoreStats>> fn) {
            return this.store(fn.apply(new StoreStats.Builder()).build());
        }

        public final Builder mappings(FieldTypesMappings value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<FieldTypesMappings.Builder, ObjectBuilder<FieldTypesMappings>> fn) {
            return this.mappings(fn.apply(new FieldTypesMappings.Builder()).build());
        }

        public final Builder analysis(CharFilterTypes value) {
            this.analysis = value;
            return this;
        }

        public final Builder analysis(Function<CharFilterTypes.Builder, ObjectBuilder<CharFilterTypes>> fn) {
            return this.analysis(fn.apply(new CharFilterTypes.Builder()).build());
        }

        public final Builder versions(List<IndicesVersions> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        public final Builder versions(IndicesVersions value, IndicesVersions ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        public final Builder versions(Function<IndicesVersions.Builder, ObjectBuilder<IndicesVersions>> fn) {
            return this.versions(fn.apply(new IndicesVersions.Builder()).build(), new IndicesVersions[0]);
        }

        @Override
        public ClusterIndices build() {
            this._checkSingleUse();
            return new ClusterIndices(this);
        }
    }
}

