/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.TermvectorsResponse;
import co.elastic.clients.elasticsearch.core.termvectors.Filter;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TermvectorsRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final TDocument doc;
    @Nullable
    private final Boolean fieldStatistics;
    private final List<String> fields;
    @Nullable
    private final Filter filter;
    @Nullable
    private final String id;
    private final String index;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final Endpoint<TermvectorsRequest<?>, TermvectorsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TermvectorsRequest, TermvectorsResponse>("es/termvectors", request -> "POST", request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_termvectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_termvectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.termStatistics != null) {
            params.put("term_statistics", String.valueOf(request.termStatistics));
        }
        if (request.offsets != null) {
            params.put("offsets", String.valueOf(request.offsets));
        }
        if (request.payloads != null) {
            params.put("payloads", String.valueOf(request.payloads));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.positions != null) {
            params.put("positions", String.valueOf(request.positions));
        }
        if (request.fieldStatistics != null) {
            params.put("field_statistics", String.valueOf(request.fieldStatistics));
        }
        if (ApiTypeHelper.isDefined(request.fields)) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, TermvectorsResponse._DESERIALIZER);

    private TermvectorsRequest(Builder<TDocument> builder) {
        this.doc = ((Builder)builder).doc;
        this.fieldStatistics = ((Builder)builder).fieldStatistics;
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.filter = ((Builder)builder).filter;
        this.id = ((Builder)builder).id;
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.offsets = ((Builder)builder).offsets;
        this.payloads = ((Builder)builder).payloads;
        this.perFieldAnalyzer = ApiTypeHelper.unmodifiable(((Builder)builder).perFieldAnalyzer);
        this.positions = ((Builder)builder).positions;
        this.preference = ((Builder)builder).preference;
        this.realtime = ((Builder)builder).realtime;
        this.routing = ((Builder)builder).routing;
        this.termStatistics = ((Builder)builder).termStatistics;
        this.version = ((Builder)builder).version;
        this.versionType = ((Builder)builder).versionType;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> TermvectorsRequest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<TermvectorsRequest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TDocument doc() {
        return this.doc;
    }

    @Nullable
    public final Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Filter filter() {
        return this.filter;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public final Boolean payloads() {
        return this.payloads;
    }

    public final Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Nullable
    public final Boolean positions() {
        return this.positions;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tDocumentSerializer, mapper);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.perFieldAnalyzer)) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<TermvectorsRequest<TDocument>> createTermvectorsRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> TermvectorsRequest.setupTermvectorsRequestDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupTermvectorsRequestDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::doc, tDocumentDeserializer, "doc");
        op.add(Builder::filter, Filter._DESERIALIZER, "filter");
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer");
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<TermvectorsRequest<TDocument>> {
        @Nullable
        private TDocument doc;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private List<String> fields;
        @Nullable
        private Filter filter;
        @Nullable
        private String id;
        private String index;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private Boolean positions;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private String routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> doc(@Nullable TDocument value) {
            this.doc = value;
            return this;
        }

        public final Builder<TDocument> fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public final Builder<TDocument> fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder<TDocument> fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder<TDocument> filter(@Nullable Filter value) {
            this.filter = value;
            return this;
        }

        public final Builder<TDocument> filter(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filter(fn.apply(new Filter.Builder()).build());
        }

        public final Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        public final Builder<TDocument> payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        public final Builder<TDocument> perFieldAnalyzer(Map<String, String> map) {
            this.perFieldAnalyzer = Builder._mapPutAll(this.perFieldAnalyzer, map);
            return this;
        }

        public final Builder<TDocument> perFieldAnalyzer(String key, String value) {
            this.perFieldAnalyzer = Builder._mapPut(this.perFieldAnalyzer, key, value);
            return this;
        }

        public final Builder<TDocument> positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        public final Builder<TDocument> preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder<TDocument> realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public TermvectorsRequest<TDocument> build() {
            this._checkSingleUse();
            return new TermvectorsRequest(this);
        }
    }
}

