/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mtermvectors;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.core.termvectors.TermVector;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiTermVectorsResult
implements JsonpSerializable {
    private final String id;
    private final String index;
    @Nullable
    private final Long version;
    @Nullable
    private final Long took;
    @Nullable
    private final Boolean found;
    private final Map<String, TermVector> termVectors;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<MultiTermVectorsResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermVectorsResult::setupMultiTermVectorsResultDeserializer);

    private MultiTermVectorsResult(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.version = builder.version;
        this.took = builder.took;
        this.found = builder.found;
        this.termVectors = ApiTypeHelper.unmodifiable(builder.termVectors);
        this.error = builder.error;
    }

    public static MultiTermVectorsResult of(Function<Builder, ObjectBuilder<MultiTermVectorsResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final Long took() {
        return this.took;
    }

    @Nullable
    public final Boolean found() {
        return this.found;
    }

    public final Map<String, TermVector> termVectors() {
        return this.termVectors;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        if (this.found != null) {
            generator.writeKey("found");
            generator.write(this.found.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.termVectors)) {
            generator.writeKey("term_vectors");
            generator.writeStartObject();
            for (Map.Entry<String, TermVector> item0 : this.termVectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    protected static void setupMultiTermVectorsResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::termVectors, JsonpDeserializer.stringMapDeserializer(TermVector._DESERIALIZER), "term_vectors");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MultiTermVectorsResult> {
        private String id;
        private String index;
        @Nullable
        private Long version;
        @Nullable
        private Long took;
        @Nullable
        private Boolean found;
        @Nullable
        private Map<String, TermVector> termVectors;
        @Nullable
        private ErrorCause error;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        public final Builder found(@Nullable Boolean value) {
            this.found = value;
            return this;
        }

        public final Builder termVectors(Map<String, TermVector> map) {
            this.termVectors = Builder._mapPutAll(this.termVectors, map);
            return this;
        }

        public final Builder termVectors(String key, TermVector value) {
            this.termVectors = Builder._mapPut(this.termVectors, key, value);
            return this;
        }

        public final Builder termVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.termVectors(key, fn.apply(new TermVector.Builder()).build());
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        public MultiTermVectorsResult build() {
            this._checkSingleUse();
            return new MultiTermVectorsResult(this);
        }
    }
}

