/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.explain_lifecycle;

import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainManaged;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainUnmanaged;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LifecycleExplain
implements TaggedUnion<Kind, LifecycleExplainVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final LifecycleExplainVariant _value;
    public static final JsonpDeserializer<LifecycleExplain> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LifecycleExplain::setupLifecycleExplainDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final LifecycleExplainVariant _get() {
        return this._value;
    }

    public LifecycleExplain(LifecycleExplainVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._lifecycleExplainKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private LifecycleExplain(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static LifecycleExplain of(Function<Builder, ObjectBuilder<LifecycleExplain>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTrue() {
        return this._kind == Kind.True;
    }

    public LifecycleExplainManaged true_() {
        return (LifecycleExplainManaged)TaggedUnionUtils.get(this, Kind.True);
    }

    public boolean isFalse() {
        return this._kind == Kind.False;
    }

    public LifecycleExplainUnmanaged false_() {
        return (LifecycleExplainUnmanaged)TaggedUnionUtils.get(this, Kind.False);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupLifecycleExplainDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::true_, LifecycleExplainManaged._DESERIALIZER, "true");
        op.add(Builder::false_, LifecycleExplainUnmanaged._DESERIALIZER, "false");
        op.setTypeProperty("managed", null);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<LifecycleExplain> {
        private Kind _kind;
        private LifecycleExplainVariant _value;

        public ObjectBuilder<LifecycleExplain> true_(LifecycleExplainManaged v) {
            this._kind = Kind.True;
            this._value = v;
            return this;
        }

        public ObjectBuilder<LifecycleExplain> true_(Function<LifecycleExplainManaged.Builder, ObjectBuilder<LifecycleExplainManaged>> fn) {
            return this.true_(fn.apply(new LifecycleExplainManaged.Builder()).build());
        }

        public ObjectBuilder<LifecycleExplain> false_(LifecycleExplainUnmanaged v) {
            this._kind = Kind.False;
            this._value = v;
            return this;
        }

        public ObjectBuilder<LifecycleExplain> false_(Function<LifecycleExplainUnmanaged.Builder, ObjectBuilder<LifecycleExplainUnmanaged>> fn) {
            return this.false_(fn.apply(new LifecycleExplainUnmanaged.Builder()).build());
        }

        @Override
        public LifecycleExplain build() {
            this._checkSingleUse();
            return new LifecycleExplain(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        True("true"),
        False("false");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

