/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocation;
import co.elastic.clients.elasticsearch.indices.IndexRoutingRebalance;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexRouting
implements JsonpSerializable {
    @Nullable
    private final IndexRoutingAllocation allocation;
    @Nullable
    private final IndexRoutingRebalance rebalance;
    public static final JsonpDeserializer<IndexRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexRouting::setupIndexRoutingDeserializer);

    private IndexRouting(Builder builder) {
        this.allocation = builder.allocation;
        this.rebalance = builder.rebalance;
    }

    public static IndexRouting of(Function<Builder, ObjectBuilder<IndexRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final IndexRoutingAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public final IndexRoutingRebalance rebalance() {
        return this.rebalance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocation != null) {
            generator.writeKey("allocation");
            this.allocation.serialize(generator, mapper);
        }
        if (this.rebalance != null) {
            generator.writeKey("rebalance");
            this.rebalance.serialize(generator, mapper);
        }
    }

    protected static void setupIndexRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocation, IndexRoutingAllocation._DESERIALIZER, "allocation");
        op.add(Builder::rebalance, IndexRoutingRebalance._DESERIALIZER, "rebalance");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexRouting> {
        @Nullable
        private IndexRoutingAllocation allocation;
        @Nullable
        private IndexRoutingRebalance rebalance;

        public final Builder allocation(@Nullable IndexRoutingAllocation value) {
            this.allocation = value;
            return this;
        }

        public final Builder allocation(Function<IndexRoutingAllocation.Builder, ObjectBuilder<IndexRoutingAllocation>> fn) {
            return this.allocation(fn.apply(new IndexRoutingAllocation.Builder()).build());
        }

        public final Builder rebalance(@Nullable IndexRoutingRebalance value) {
            this.rebalance = value;
            return this;
        }

        public final Builder rebalance(Function<IndexRoutingRebalance.Builder, ObjectBuilder<IndexRoutingRebalance>> fn) {
            return this.rebalance(fn.apply(new IndexRoutingRebalance.Builder()).build());
        }

        @Override
        public IndexRouting build() {
            this._checkSingleUse();
            return new IndexRouting(this);
        }
    }
}

