/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Recording;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterAppliedStats
implements JsonpSerializable {
    private final List<Recording> recordings;
    public static final JsonpDeserializer<ClusterAppliedStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterAppliedStats::setupClusterAppliedStatsDeserializer);

    private ClusterAppliedStats(Builder builder) {
        this.recordings = ApiTypeHelper.unmodifiable(builder.recordings);
    }

    public static ClusterAppliedStats of(Function<Builder, ObjectBuilder<ClusterAppliedStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Recording> recordings() {
        return this.recordings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.recordings)) {
            generator.writeKey("recordings");
            generator.writeStartArray();
            for (Recording item0 : this.recordings) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterAppliedStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::recordings, JsonpDeserializer.arrayDeserializer(Recording._DESERIALIZER), "recordings");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterAppliedStats> {
        @Nullable
        private List<Recording> recordings;

        public final Builder recordings(List<Recording> list) {
            this.recordings = Builder._listAddAll(this.recordings, list);
            return this;
        }

        public final Builder recordings(Recording value, Recording ... values) {
            this.recordings = Builder._listAdd(this.recordings, value, values);
            return this;
        }

        public final Builder recordings(Function<Recording.Builder, ObjectBuilder<Recording>> fn) {
            return this.recordings(fn.apply(new Recording.Builder()).build(), new Recording[0]);
        }

        @Override
        public ClusterAppliedStats build() {
            this._checkSingleUse();
            return new ClusterAppliedStats(this);
        }
    }
}

