/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExecutionState
implements JsonpSerializable {
    private final boolean successful;
    private final DateTime timestamp;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<ExecutionState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionState::setupExecutionStateDeserializer);

    private ExecutionState(Builder builder) {
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, this, "successful");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.reason = builder.reason;
    }

    public static ExecutionState of(Function<Builder, ObjectBuilder<ExecutionState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean successful() {
        return this.successful;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupExecutionStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::successful, JsonpDeserializer.booleanDeserializer(), "successful");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExecutionState> {
        private Boolean successful;
        private DateTime timestamp;
        @Nullable
        private String reason;

        public final Builder successful(boolean value) {
            this.successful = value;
            return this;
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        public ExecutionState build() {
            this._checkSingleUse();
            return new ExecutionState(this);
        }
    }
}

