/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HourAndMinute
implements JsonpSerializable {
    private final List<Integer> hour;
    private final List<Integer> minute;
    public static final JsonpDeserializer<HourAndMinute> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HourAndMinute::setupHourAndMinuteDeserializer);

    private HourAndMinute(Builder builder) {
        this.hour = ApiTypeHelper.unmodifiableRequired(builder.hour, (Object)this, "hour");
        this.minute = ApiTypeHelper.unmodifiableRequired(builder.minute, (Object)this, "minute");
    }

    public static HourAndMinute of(Function<Builder, ObjectBuilder<HourAndMinute>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Integer> hour() {
        return this.hour;
    }

    public final List<Integer> minute() {
        return this.minute;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.hour)) {
            generator.writeKey("hour");
            generator.writeStartArray();
            for (Integer item0 : this.hour) {
                generator.write(item0.intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.minute)) {
            generator.writeKey("minute");
            generator.writeStartArray();
            for (Integer item0 : this.minute) {
                generator.write(item0.intValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupHourAndMinuteDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hour, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "hour");
        op.add(Builder::minute, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "minute");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HourAndMinute> {
        private List<Integer> hour;
        private List<Integer> minute;

        public final Builder hour(List<Integer> list) {
            this.hour = Builder._listAddAll(this.hour, list);
            return this;
        }

        public final Builder hour(Integer value, Integer ... values) {
            this.hour = Builder._listAdd(this.hour, value, values);
            return this;
        }

        public final Builder minute(List<Integer> list) {
            this.minute = Builder._listAddAll(this.minute, list);
            return this;
        }

        public final Builder minute(Integer value, Integer ... values) {
            this.minute = Builder._listAdd(this.minute, value, values);
            return this;
        }

        @Override
        public HourAndMinute build() {
            this._checkSingleUse();
            return new HourAndMinute(this);
        }
    }
}

