/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class BuildInformation
implements JsonpSerializable {
    private final DateTime date;
    private final String hash;
    public static final JsonpDeserializer<BuildInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BuildInformation::setupBuildInformationDeserializer);

    private BuildInformation(Builder builder) {
        this.date = ApiTypeHelper.requireNonNull(builder.date, this, "date");
        this.hash = ApiTypeHelper.requireNonNull(builder.hash, this, "hash");
    }

    public static BuildInformation of(Function<Builder, ObjectBuilder<BuildInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DateTime date() {
        return this.date;
    }

    public final String hash() {
        return this.hash;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("date");
        this.date.serialize(generator, mapper);
        generator.writeKey("hash");
        generator.write(this.hash);
    }

    protected static void setupBuildInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::date, DateTime._DESERIALIZER, "date");
        op.add(Builder::hash, JsonpDeserializer.stringDeserializer(), "hash");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BuildInformation> {
        private DateTime date;
        private String hash;

        public final Builder date(DateTime value) {
            this.date = value;
            return this;
        }

        public final Builder hash(String value) {
            this.hash = value;
            return this;
        }

        @Override
        public BuildInformation build() {
            this._checkSingleUse();
            return new BuildInformation(this);
        }
    }
}

