/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Base
implements JsonpSerializable {
    private final boolean available;
    private final boolean enabled;
    public static final JsonpDeserializer<Base> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Base::setupBaseDeserializer);

    protected Base(AbstractBuilder<?> builder) {
        this.available = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).available, this, "available");
        this.enabled = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).enabled, this, "enabled");
    }

    public static Base baseOf(Function<Builder, ObjectBuilder<Base>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean available() {
        return this.available;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("enabled");
        generator.write(this.enabled);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::available, JsonpDeserializer.booleanDeserializer(), "available");
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private Boolean available;
        private Boolean enabled;

        protected AbstractBuilder() {
        }

        public final BuilderT available(boolean value) {
            this.available = value;
            return this.self();
        }

        public final BuilderT enabled(boolean value) {
            this.enabled = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Base> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Base build() {
            this._checkSingleUse();
            return new Base(this);
        }
    }
}

