/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_lifecycle;

import co.elastic.clients.elasticsearch.indices.DataStreamLifecycle;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamWithLifecycle
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    public static final JsonpDeserializer<DataStreamWithLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamWithLifecycle::setupDataStreamWithLifecycleDeserializer);

    private DataStreamWithLifecycle(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.lifecycle = builder.lifecycle;
    }

    public static DataStreamWithLifecycle of(Function<Builder, ObjectBuilder<DataStreamWithLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final DataStreamLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.lifecycle != null) {
            generator.writeKey("lifecycle");
            this.lifecycle.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamWithLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::lifecycle, DataStreamLifecycle._DESERIALIZER, "lifecycle");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamWithLifecycle> {
        private String name;
        @Nullable
        private DataStreamLifecycle lifecycle;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder lifecycle(@Nullable DataStreamLifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<DataStreamLifecycle.Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
            return this.lifecycle(fn.apply(new DataStreamLifecycle.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamWithLifecycle build() {
            this._checkSingleUse();
            return new DataStreamWithLifecycle(this);
        }
    }
}

