/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionSuggester;
import co.elastic.clients.elasticsearch.core.search.FieldSuggesterVariant;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggester;
import co.elastic.clients.elasticsearch.core.search.TermSuggester;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldSuggester
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String prefix;
    @Nullable
    private final String regex;
    @Nullable
    private final String text;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<FieldSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSuggester::setupFieldSuggesterDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public FieldSuggester(FieldSuggesterVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._fieldSuggesterKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
        this.prefix = null;
        this.regex = null;
        this.text = null;
    }

    private FieldSuggester(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
        this.prefix = builder.prefix;
        this.regex = builder.regex;
        this.text = builder.text;
    }

    public static FieldSuggester of(Function<Builder, ObjectBuilder<FieldSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final String regex() {
        return this.regex;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggester completion() {
        return (CompletionSuggester)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggester phrase() {
        return (PhraseSuggester)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggester term() {
        return (TermSuggester)TaggedUnionUtils.get(this, Kind.Term);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.regex != null) {
            generator.writeKey("regex");
            generator.write(this.regex);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::completion, CompletionSuggester._DESERIALIZER, "completion");
        op.add(Builder::phrase, PhraseSuggester._DESERIALIZER, "phrase");
        op.add(Builder::term, TermSuggester._DESERIALIZER, "term");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder> {
        private Kind _kind;
        private Object _value;
        private String _customKind;
        @Nullable
        private String prefix;
        @Nullable
        private String regex;
        @Nullable
        private String text;

        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        public final Builder regex(@Nullable String value) {
            this.regex = value;
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder completion(CompletionSuggester v) {
            this._kind = Kind.Completion;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder completion(Function<CompletionSuggester.Builder, ObjectBuilder<CompletionSuggester>> fn) {
            return this.completion(fn.apply(new CompletionSuggester.Builder()).build());
        }

        public ContainerBuilder phrase(PhraseSuggester v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder phrase(Function<PhraseSuggester.Builder, ObjectBuilder<PhraseSuggester>> fn) {
            return this.phrase(fn.apply(new PhraseSuggester.Builder()).build());
        }

        public ContainerBuilder term(TermSuggester v) {
            this._kind = Kind.Term;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder term(Function<TermSuggester.Builder, ObjectBuilder<TermSuggester>> fn) {
            return this.term(fn.apply(new TermSuggester.Builder()).build());
        }

        public ContainerBuilder _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return new ContainerBuilder();
        }

        protected FieldSuggester build() {
            this._checkSingleUse();
            return new FieldSuggester(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<FieldSuggester> {
            public final ContainerBuilder prefix(@Nullable String value) {
                Builder.this.prefix = value;
                return this;
            }

            public final ContainerBuilder regex(@Nullable String value) {
                Builder.this.regex = value;
                return this;
            }

            public final ContainerBuilder text(@Nullable String value) {
                Builder.this.text = value;
                return this;
            }

            @Override
            public FieldSuggester build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Completion("completion"),
        Phrase("phrase"),
        Term("term"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

