/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.close;

import co.elastic.clients.elasticsearch.indices.close.CloseShardResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CloseIndexResult
implements JsonpSerializable {
    private final boolean closed;
    private final Map<String, CloseShardResult> shards;
    public static final JsonpDeserializer<CloseIndexResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseIndexResult::setupCloseIndexResultDeserializer);

    private CloseIndexResult(Builder builder) {
        this.closed = ApiTypeHelper.requireNonNull(builder.closed, this, "closed");
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
    }

    public static CloseIndexResult of(Function<Builder, ObjectBuilder<CloseIndexResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean closed() {
        return this.closed;
    }

    public final Map<String, CloseShardResult> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("closed");
        generator.write(this.closed);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, CloseShardResult> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCloseIndexResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::closed, JsonpDeserializer.booleanDeserializer(), "closed");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(CloseShardResult._DESERIALIZER), "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CloseIndexResult> {
        private Boolean closed;
        @Nullable
        private Map<String, CloseShardResult> shards;

        public final Builder closed(boolean value) {
            this.closed = value;
            return this;
        }

        public final Builder shards(Map<String, CloseShardResult> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, CloseShardResult value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        public final Builder shards(String key, Function<CloseShardResult.Builder, ObjectBuilder<CloseShardResult>> fn) {
            return this.shards(key, fn.apply(new CloseShardResult.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloseIndexResult build() {
            this._checkSingleUse();
            return new CloseIndexResult(this);
        }
    }
}

