/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Settings
implements JsonpSerializable {
    @Nullable
    private final Boolean alignCheckpoints;
    @Nullable
    private final Boolean datesAsEpochMillis;
    @Nullable
    private final Boolean deduceMappings;
    @Nullable
    private final Float docsPerSecond;
    @Nullable
    private final Integer maxPageSearchSize;
    @Nullable
    private final Boolean unattended;
    public static final JsonpDeserializer<Settings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Settings::setupSettingsDeserializer);

    private Settings(Builder builder) {
        this.alignCheckpoints = builder.alignCheckpoints;
        this.datesAsEpochMillis = builder.datesAsEpochMillis;
        this.deduceMappings = builder.deduceMappings;
        this.docsPerSecond = builder.docsPerSecond;
        this.maxPageSearchSize = builder.maxPageSearchSize;
        this.unattended = builder.unattended;
    }

    public static Settings of(Function<Builder, ObjectBuilder<Settings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean alignCheckpoints() {
        return this.alignCheckpoints;
    }

    @Nullable
    public final Boolean datesAsEpochMillis() {
        return this.datesAsEpochMillis;
    }

    @Nullable
    public final Boolean deduceMappings() {
        return this.deduceMappings;
    }

    @Nullable
    public final Float docsPerSecond() {
        return this.docsPerSecond;
    }

    @Nullable
    public final Integer maxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    @Nullable
    public final Boolean unattended() {
        return this.unattended;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alignCheckpoints != null) {
            generator.writeKey("align_checkpoints");
            generator.write(this.alignCheckpoints.booleanValue());
        }
        if (this.datesAsEpochMillis != null) {
            generator.writeKey("dates_as_epoch_millis");
            generator.write(this.datesAsEpochMillis.booleanValue());
        }
        if (this.deduceMappings != null) {
            generator.writeKey("deduce_mappings");
            generator.write(this.deduceMappings.booleanValue());
        }
        if (this.docsPerSecond != null) {
            generator.writeKey("docs_per_second");
            generator.write((double)this.docsPerSecond.floatValue());
        }
        if (this.maxPageSearchSize != null) {
            generator.writeKey("max_page_search_size");
            generator.write(this.maxPageSearchSize.intValue());
        }
        if (this.unattended != null) {
            generator.writeKey("unattended");
            generator.write(this.unattended.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alignCheckpoints, JsonpDeserializer.booleanDeserializer(), "align_checkpoints");
        op.add(Builder::datesAsEpochMillis, JsonpDeserializer.booleanDeserializer(), "dates_as_epoch_millis");
        op.add(Builder::deduceMappings, JsonpDeserializer.booleanDeserializer(), "deduce_mappings");
        op.add(Builder::docsPerSecond, JsonpDeserializer.floatDeserializer(), "docs_per_second");
        op.add(Builder::maxPageSearchSize, JsonpDeserializer.integerDeserializer(), "max_page_search_size");
        op.add(Builder::unattended, JsonpDeserializer.booleanDeserializer(), "unattended");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Settings> {
        @Nullable
        private Boolean alignCheckpoints;
        @Nullable
        private Boolean datesAsEpochMillis;
        @Nullable
        private Boolean deduceMappings;
        @Nullable
        private Float docsPerSecond;
        @Nullable
        private Integer maxPageSearchSize;
        @Nullable
        private Boolean unattended;

        public final Builder alignCheckpoints(@Nullable Boolean value) {
            this.alignCheckpoints = value;
            return this;
        }

        public final Builder datesAsEpochMillis(@Nullable Boolean value) {
            this.datesAsEpochMillis = value;
            return this;
        }

        public final Builder deduceMappings(@Nullable Boolean value) {
            this.deduceMappings = value;
            return this;
        }

        public final Builder docsPerSecond(@Nullable Float value) {
            this.docsPerSecond = value;
            return this;
        }

        public final Builder maxPageSearchSize(@Nullable Integer value) {
            this.maxPageSearchSize = value;
            return this;
        }

        public final Builder unattended(@Nullable Boolean value) {
            this.unattended = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Settings build() {
            this._checkSingleUse();
            return new Settings(this);
        }
    }
}

