/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FollowResponse
implements JsonpSerializable {
    private final boolean followIndexCreated;
    private final boolean followIndexShardsAcked;
    private final boolean indexFollowingStarted;
    public static final JsonpDeserializer<FollowResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowResponse::setupFollowResponseDeserializer);

    private FollowResponse(Builder builder) {
        this.followIndexCreated = ApiTypeHelper.requireNonNull(builder.followIndexCreated, this, "followIndexCreated");
        this.followIndexShardsAcked = ApiTypeHelper.requireNonNull(builder.followIndexShardsAcked, this, "followIndexShardsAcked");
        this.indexFollowingStarted = ApiTypeHelper.requireNonNull(builder.indexFollowingStarted, this, "indexFollowingStarted");
    }

    public static FollowResponse of(Function<Builder, ObjectBuilder<FollowResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean followIndexCreated() {
        return this.followIndexCreated;
    }

    public final boolean followIndexShardsAcked() {
        return this.followIndexShardsAcked;
    }

    public final boolean indexFollowingStarted() {
        return this.indexFollowingStarted;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("follow_index_created");
        generator.write(this.followIndexCreated);
        generator.writeKey("follow_index_shards_acked");
        generator.write(this.followIndexShardsAcked);
        generator.writeKey("index_following_started");
        generator.write(this.indexFollowingStarted);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFollowResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::followIndexCreated, JsonpDeserializer.booleanDeserializer(), "follow_index_created");
        op.add(Builder::followIndexShardsAcked, JsonpDeserializer.booleanDeserializer(), "follow_index_shards_acked");
        op.add(Builder::indexFollowingStarted, JsonpDeserializer.booleanDeserializer(), "index_following_started");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FollowResponse> {
        private Boolean followIndexCreated;
        private Boolean followIndexShardsAcked;
        private Boolean indexFollowingStarted;

        public final Builder followIndexCreated(boolean value) {
            this.followIndexCreated = value;
            return this;
        }

        public final Builder followIndexShardsAcked(boolean value) {
            this.followIndexShardsAcked = value;
            return this;
        }

        public final Builder indexFollowingStarted(boolean value) {
            this.indexFollowingStarted = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FollowResponse build() {
            this._checkSingleUse();
            return new FollowResponse(this);
        }
    }
}

