/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TestPopulation
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final Script script;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<TestPopulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TestPopulation::setupTestPopulationDeserializer);

    private TestPopulation(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.script = builder.script;
        this.filter = builder.filter;
    }

    public static TestPopulation of(Function<Builder, ObjectBuilder<TestPopulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTestPopulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TestPopulation> {
        private String field;
        @Nullable
        private Script script;
        @Nullable
        private Query filter;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TestPopulation build() {
            this._checkSingleUse();
            return new TestPopulation(this);
        }
    }
}

