/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TimeSeriesAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final Integer size;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<TimeSeriesAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeSeriesAggregation::setupTimeSeriesAggregationDeserializer);

    private TimeSeriesAggregation(Builder builder) {
        this.size = builder.size;
        this.keyed = builder.keyed;
    }

    public static TimeSeriesAggregation of(Function<Builder, ObjectBuilder<TimeSeriesAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.TimeSeries;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTimeSeriesAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TimeSeriesAggregation> {
        @Nullable
        private Integer size;
        @Nullable
        private Boolean keyed;

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimeSeriesAggregation build() {
            this._checkSingleUse();
            return new TimeSeriesAggregation(this);
        }
    }
}

