/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChunkingSettings
implements JsonpSerializable {
    private final String strategy;
    private final int maxChunkSize;
    @Nullable
    private final Integer overlap;
    @Nullable
    private final Integer sentenceOverlap;
    public static final JsonpDeserializer<ChunkingSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChunkingSettings::setupChunkingSettingsDeserializer);

    private ChunkingSettings(Builder builder) {
        this.strategy = ApiTypeHelper.requireNonNull(builder.strategy, this, "strategy");
        this.maxChunkSize = ApiTypeHelper.requireNonNull(builder.maxChunkSize, (Object)this, "maxChunkSize", 0);
        this.overlap = builder.overlap;
        this.sentenceOverlap = builder.sentenceOverlap;
    }

    public static ChunkingSettings of(Function<Builder, ObjectBuilder<ChunkingSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String strategy() {
        return this.strategy;
    }

    public final int maxChunkSize() {
        return this.maxChunkSize;
    }

    @Nullable
    public final Integer overlap() {
        return this.overlap;
    }

    @Nullable
    public final Integer sentenceOverlap() {
        return this.sentenceOverlap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("strategy");
        generator.write(this.strategy);
        generator.writeKey("max_chunk_size");
        generator.write(this.maxChunkSize);
        if (this.overlap != null) {
            generator.writeKey("overlap");
            generator.write(this.overlap.intValue());
        }
        if (this.sentenceOverlap != null) {
            generator.writeKey("sentence_overlap");
            generator.write(this.sentenceOverlap.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChunkingSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::strategy, JsonpDeserializer.stringDeserializer(), "strategy");
        op.add(Builder::maxChunkSize, JsonpDeserializer.integerDeserializer(), "max_chunk_size");
        op.add(Builder::overlap, JsonpDeserializer.integerDeserializer(), "overlap");
        op.add(Builder::sentenceOverlap, JsonpDeserializer.integerDeserializer(), "sentence_overlap");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChunkingSettings> {
        private String strategy;
        private Integer maxChunkSize;
        @Nullable
        private Integer overlap;
        @Nullable
        private Integer sentenceOverlap;

        public final Builder strategy(String value) {
            this.strategy = value;
            return this;
        }

        public final Builder maxChunkSize(int value) {
            this.maxChunkSize = value;
            return this;
        }

        public final Builder overlap(@Nullable Integer value) {
            this.overlap = value;
            return this;
        }

        public final Builder sentenceOverlap(@Nullable Integer value) {
            this.sentenceOverlap = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChunkingSettings build() {
            this._checkSingleUse();
            return new ChunkingSettings(this);
        }
    }
}

