/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.graph.VertexDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Hop
implements JsonpSerializable {
    @Nullable
    private final Hop connections;
    private final Query query;
    private final List<VertexDefinition> vertices;
    public static final JsonpDeserializer<Hop> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hop::setupHopDeserializer);

    private Hop(Builder builder) {
        this.connections = builder.connections;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.vertices = ApiTypeHelper.unmodifiableRequired(builder.vertices, (Object)this, "vertices");
    }

    public static Hop of(Function<Builder, ObjectBuilder<Hop>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Hop connections() {
        return this.connections;
    }

    public final Query query() {
        return this.query;
    }

    public final List<VertexDefinition> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connections != null) {
            generator.writeKey("connections");
            this.connections.serialize(generator, mapper);
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.vertices)) {
            generator.writeKey("vertices");
            generator.writeStartArray();
            for (VertexDefinition item0 : this.vertices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHopDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connections, _DESERIALIZER, "connections");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(VertexDefinition._DESERIALIZER), "vertices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Hop> {
        @Nullable
        private Hop connections;
        private Query query;
        private List<VertexDefinition> vertices;

        public final Builder connections(@Nullable Hop value) {
            this.connections = value;
            return this;
        }

        public final Builder connections(Function<Builder, ObjectBuilder<Hop>> fn) {
            return this.connections(fn.apply(new Builder()).build());
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder vertices(List<VertexDefinition> list) {
            this.vertices = Builder._listAddAll(this.vertices, list);
            return this;
        }

        public final Builder vertices(VertexDefinition value, VertexDefinition ... values) {
            this.vertices = Builder._listAdd(this.vertices, value, values);
            return this;
        }

        public final Builder vertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.vertices(fn.apply(new VertexDefinition.Builder()).build(), new VertexDefinition[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Hop build() {
            this._checkSingleUse();
            return new Hop(this);
        }
    }
}

