/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AdaptiveAllocationsSettings;
import co.elastic.clients.elasticsearch.ml.DeploymentAssignmentState;
import co.elastic.clients.elasticsearch.ml.TrainedModelDeploymentAllocationStatus;
import co.elastic.clients.elasticsearch.ml.TrainedModelDeploymentNodesStats;
import co.elastic.clients.elasticsearch.ml.TrainingPriority;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelDeploymentStats
implements JsonpSerializable {
    @Nullable
    private final AdaptiveAllocationsSettings adaptiveAllocations;
    @Nullable
    private final TrainedModelDeploymentAllocationStatus allocationStatus;
    @Nullable
    private final String cacheSize;
    private final String deploymentId;
    @Nullable
    private final Integer errorCount;
    @Nullable
    private final Integer inferenceCount;
    private final String modelId;
    private final List<TrainedModelDeploymentNodesStats> nodes;
    @Nullable
    private final Integer numberOfAllocations;
    private final long peakThroughputPerMinute;
    private final TrainingPriority priority;
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final Integer rejectedExecutionCount;
    @Nullable
    private final String reason;
    private final long startTime;
    @Nullable
    private final DeploymentAssignmentState state;
    @Nullable
    private final Integer threadsPerAllocation;
    @Nullable
    private final Integer timeoutCount;
    public static final JsonpDeserializer<TrainedModelDeploymentStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentStats::setupTrainedModelDeploymentStatsDeserializer);

    private TrainedModelDeploymentStats(Builder builder) {
        this.adaptiveAllocations = builder.adaptiveAllocations;
        this.allocationStatus = builder.allocationStatus;
        this.cacheSize = builder.cacheSize;
        this.deploymentId = ApiTypeHelper.requireNonNull(builder.deploymentId, this, "deploymentId");
        this.errorCount = builder.errorCount;
        this.inferenceCount = builder.inferenceCount;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
        this.numberOfAllocations = builder.numberOfAllocations;
        this.peakThroughputPerMinute = ApiTypeHelper.requireNonNull(builder.peakThroughputPerMinute, (Object)this, "peakThroughputPerMinute", 0L);
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.queueCapacity = builder.queueCapacity;
        this.rejectedExecutionCount = builder.rejectedExecutionCount;
        this.reason = builder.reason;
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, (Object)this, "startTime", 0L);
        this.state = builder.state;
        this.threadsPerAllocation = builder.threadsPerAllocation;
        this.timeoutCount = builder.timeoutCount;
    }

    public static TrainedModelDeploymentStats of(Function<Builder, ObjectBuilder<TrainedModelDeploymentStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AdaptiveAllocationsSettings adaptiveAllocations() {
        return this.adaptiveAllocations;
    }

    @Nullable
    public final TrainedModelDeploymentAllocationStatus allocationStatus() {
        return this.allocationStatus;
    }

    @Nullable
    public final String cacheSize() {
        return this.cacheSize;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    @Nullable
    public final Integer errorCount() {
        return this.errorCount;
    }

    @Nullable
    public final Integer inferenceCount() {
        return this.inferenceCount;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final List<TrainedModelDeploymentNodesStats> nodes() {
        return this.nodes;
    }

    @Nullable
    public final Integer numberOfAllocations() {
        return this.numberOfAllocations;
    }

    public final long peakThroughputPerMinute() {
        return this.peakThroughputPerMinute;
    }

    public final TrainingPriority priority() {
        return this.priority;
    }

    @Nullable
    public final Integer queueCapacity() {
        return this.queueCapacity;
    }

    @Nullable
    public final Integer rejectedExecutionCount() {
        return this.rejectedExecutionCount;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    public final long startTime() {
        return this.startTime;
    }

    @Nullable
    public final DeploymentAssignmentState state() {
        return this.state;
    }

    @Nullable
    public final Integer threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Nullable
    public final Integer timeoutCount() {
        return this.timeoutCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adaptiveAllocations != null) {
            generator.writeKey("adaptive_allocations");
            this.adaptiveAllocations.serialize(generator, mapper);
        }
        if (this.allocationStatus != null) {
            generator.writeKey("allocation_status");
            this.allocationStatus.serialize(generator, mapper);
        }
        if (this.cacheSize != null) {
            generator.writeKey("cache_size");
            generator.write(this.cacheSize);
        }
        generator.writeKey("deployment_id");
        generator.write(this.deploymentId);
        if (this.errorCount != null) {
            generator.writeKey("error_count");
            generator.write(this.errorCount.intValue());
        }
        if (this.inferenceCount != null) {
            generator.writeKey("inference_count");
            generator.write(this.inferenceCount.intValue());
        }
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartArray();
            for (TrainedModelDeploymentNodesStats item0 : this.nodes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numberOfAllocations != null) {
            generator.writeKey("number_of_allocations");
            generator.write(this.numberOfAllocations.intValue());
        }
        generator.writeKey("peak_throughput_per_minute");
        generator.write(this.peakThroughputPerMinute);
        generator.writeKey("priority");
        this.priority.serialize(generator, mapper);
        if (this.queueCapacity != null) {
            generator.writeKey("queue_capacity");
            generator.write(this.queueCapacity.intValue());
        }
        if (this.rejectedExecutionCount != null) {
            generator.writeKey("rejected_execution_count");
            generator.write(this.rejectedExecutionCount.intValue());
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        generator.writeKey("start_time");
        generator.write(this.startTime);
        if (this.state != null) {
            generator.writeKey("state");
            this.state.serialize(generator, mapper);
        }
        if (this.threadsPerAllocation != null) {
            generator.writeKey("threads_per_allocation");
            generator.write(this.threadsPerAllocation.intValue());
        }
        if (this.timeoutCount != null) {
            generator.writeKey("timeout_count");
            generator.write(this.timeoutCount.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelDeploymentStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveAllocations, AdaptiveAllocationsSettings._DESERIALIZER, "adaptive_allocations");
        op.add(Builder::allocationStatus, TrainedModelDeploymentAllocationStatus._DESERIALIZER, "allocation_status");
        op.add(Builder::cacheSize, JsonpDeserializer.stringDeserializer(), "cache_size");
        op.add(Builder::deploymentId, JsonpDeserializer.stringDeserializer(), "deployment_id");
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.integerDeserializer(), "inference_count");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::nodes, JsonpDeserializer.arrayDeserializer(TrainedModelDeploymentNodesStats._DESERIALIZER), "nodes");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::peakThroughputPerMinute, JsonpDeserializer.longDeserializer(), "peak_throughput_per_minute");
        op.add(Builder::priority, TrainingPriority._DESERIALIZER, "priority");
        op.add(Builder::queueCapacity, JsonpDeserializer.integerDeserializer(), "queue_capacity");
        op.add(Builder::rejectedExecutionCount, JsonpDeserializer.integerDeserializer(), "rejected_execution_count");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::startTime, JsonpDeserializer.longDeserializer(), "start_time");
        op.add(Builder::state, DeploymentAssignmentState._DESERIALIZER, "state");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
        op.add(Builder::timeoutCount, JsonpDeserializer.integerDeserializer(), "timeout_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentStats> {
        @Nullable
        private AdaptiveAllocationsSettings adaptiveAllocations;
        @Nullable
        private TrainedModelDeploymentAllocationStatus allocationStatus;
        @Nullable
        private String cacheSize;
        private String deploymentId;
        @Nullable
        private Integer errorCount;
        @Nullable
        private Integer inferenceCount;
        private String modelId;
        private List<TrainedModelDeploymentNodesStats> nodes;
        @Nullable
        private Integer numberOfAllocations;
        private Long peakThroughputPerMinute;
        private TrainingPriority priority;
        @Nullable
        private Integer queueCapacity;
        @Nullable
        private Integer rejectedExecutionCount;
        @Nullable
        private String reason;
        private Long startTime;
        @Nullable
        private DeploymentAssignmentState state;
        @Nullable
        private Integer threadsPerAllocation;
        @Nullable
        private Integer timeoutCount;

        public final Builder adaptiveAllocations(@Nullable AdaptiveAllocationsSettings value) {
            this.adaptiveAllocations = value;
            return this;
        }

        public final Builder adaptiveAllocations(Function<AdaptiveAllocationsSettings.Builder, ObjectBuilder<AdaptiveAllocationsSettings>> fn) {
            return this.adaptiveAllocations(fn.apply(new AdaptiveAllocationsSettings.Builder()).build());
        }

        public final Builder allocationStatus(@Nullable TrainedModelDeploymentAllocationStatus value) {
            this.allocationStatus = value;
            return this;
        }

        public final Builder allocationStatus(Function<TrainedModelDeploymentAllocationStatus.Builder, ObjectBuilder<TrainedModelDeploymentAllocationStatus>> fn) {
            return this.allocationStatus(fn.apply(new TrainedModelDeploymentAllocationStatus.Builder()).build());
        }

        public final Builder cacheSize(@Nullable String value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder deploymentId(String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder errorCount(@Nullable Integer value) {
            this.errorCount = value;
            return this;
        }

        public final Builder inferenceCount(@Nullable Integer value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder nodes(List<TrainedModelDeploymentNodesStats> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        public final Builder nodes(TrainedModelDeploymentNodesStats value, TrainedModelDeploymentNodesStats ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        public final Builder nodes(Function<TrainedModelDeploymentNodesStats.Builder, ObjectBuilder<TrainedModelDeploymentNodesStats>> fn) {
            return this.nodes(fn.apply(new TrainedModelDeploymentNodesStats.Builder()).build(), new TrainedModelDeploymentNodesStats[0]);
        }

        public final Builder numberOfAllocations(@Nullable Integer value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder peakThroughputPerMinute(long value) {
            this.peakThroughputPerMinute = value;
            return this;
        }

        public final Builder priority(TrainingPriority value) {
            this.priority = value;
            return this;
        }

        public final Builder queueCapacity(@Nullable Integer value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder rejectedExecutionCount(@Nullable Integer value) {
            this.rejectedExecutionCount = value;
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder startTime(long value) {
            this.startTime = value;
            return this;
        }

        public final Builder state(@Nullable DeploymentAssignmentState value) {
            this.state = value;
            return this;
        }

        public final Builder threadsPerAllocation(@Nullable Integer value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder timeoutCount(@Nullable Integer value) {
            this.timeoutCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentStats build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentStats(this);
        }
    }
}

