/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TimeHttpHistogram
implements JsonpSerializable {
    private final long count;
    @Nullable
    private final Long geMillis;
    @Nullable
    private final Long ltMillis;
    public static final JsonpDeserializer<TimeHttpHistogram> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeHttpHistogram::setupTimeHttpHistogramDeserializer);

    private TimeHttpHistogram(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.geMillis = builder.geMillis;
        this.ltMillis = builder.ltMillis;
    }

    public static TimeHttpHistogram of(Function<Builder, ObjectBuilder<TimeHttpHistogram>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Long geMillis() {
        return this.geMillis;
    }

    @Nullable
    public final Long ltMillis() {
        return this.ltMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.geMillis != null) {
            generator.writeKey("ge_millis");
            generator.write(this.geMillis.longValue());
        }
        if (this.ltMillis != null) {
            generator.writeKey("lt_millis");
            generator.write(this.ltMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTimeHttpHistogramDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::geMillis, JsonpDeserializer.longDeserializer(), "ge_millis");
        op.add(Builder::ltMillis, JsonpDeserializer.longDeserializer(), "lt_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TimeHttpHistogram> {
        private Long count;
        @Nullable
        private Long geMillis;
        @Nullable
        private Long ltMillis;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder geMillis(@Nullable Long value) {
            this.geMillis = value;
            return this;
        }

        public final Builder ltMillis(@Nullable Long value) {
            this.ltMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimeHttpHistogram build() {
            this._checkSingleUse();
            return new TimeHttpHistogram(this);
        }
    }
}

