/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class NodeInfoTransport
implements JsonpSerializable {
    private final List<String> boundAddress;
    private final String publishAddress;
    private final Map<String, String> profiles;
    public static final JsonpDeserializer<NodeInfoTransport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoTransport::setupNodeInfoTransportDeserializer);

    private NodeInfoTransport(Builder builder) {
        this.boundAddress = ApiTypeHelper.unmodifiableRequired(builder.boundAddress, (Object)this, "boundAddress");
        this.publishAddress = ApiTypeHelper.requireNonNull(builder.publishAddress, this, "publishAddress");
        this.profiles = ApiTypeHelper.unmodifiableRequired(builder.profiles, (Object)this, "profiles");
    }

    public static NodeInfoTransport of(Function<Builder, ObjectBuilder<NodeInfoTransport>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> boundAddress() {
        return this.boundAddress;
    }

    public final String publishAddress() {
        return this.publishAddress;
    }

    public final Map<String, String> profiles() {
        return this.profiles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.boundAddress)) {
            generator.writeKey("bound_address");
            generator.writeStartArray();
            for (String string : this.boundAddress) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
        if (ApiTypeHelper.isDefined(this.profiles)) {
            generator.writeKey("profiles");
            generator.writeStartObject();
            for (Map.Entry entry : this.profiles.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address");
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address");
        op.add(Builder::profiles, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "profiles");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoTransport> {
        private List<String> boundAddress;
        private String publishAddress;
        private Map<String, String> profiles;

        public final Builder boundAddress(List<String> list) {
            this.boundAddress = Builder._listAddAll(this.boundAddress, list);
            return this;
        }

        public final Builder boundAddress(String value, String ... values) {
            this.boundAddress = Builder._listAdd(this.boundAddress, value, values);
            return this;
        }

        public final Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        public final Builder profiles(Map<String, String> map) {
            this.profiles = Builder._mapPutAll(this.profiles, map);
            return this;
        }

        public final Builder profiles(String key, String value) {
            this.profiles = Builder._mapPut(this.profiles, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoTransport build() {
            this._checkSingleUse();
            return new NodeInfoTransport(this);
        }
    }
}

