/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Ccr
extends Base {
    private final int autoFollowPatternsCount;
    private final int followerIndicesCount;
    public static final JsonpDeserializer<Ccr> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ccr::setupCcrDeserializer);

    private Ccr(Builder builder) {
        super(builder);
        this.autoFollowPatternsCount = ApiTypeHelper.requireNonNull(builder.autoFollowPatternsCount, (Object)this, "autoFollowPatternsCount", 0);
        this.followerIndicesCount = ApiTypeHelper.requireNonNull(builder.followerIndicesCount, (Object)this, "followerIndicesCount", 0);
    }

    public static Ccr of(Function<Builder, ObjectBuilder<Ccr>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int autoFollowPatternsCount() {
        return this.autoFollowPatternsCount;
    }

    public final int followerIndicesCount() {
        return this.followerIndicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("auto_follow_patterns_count");
        generator.write(this.autoFollowPatternsCount);
        generator.writeKey("follower_indices_count");
        generator.write(this.followerIndicesCount);
    }

    protected static void setupCcrDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::autoFollowPatternsCount, JsonpDeserializer.integerDeserializer(), "auto_follow_patterns_count");
        op.add(Builder::followerIndicesCount, JsonpDeserializer.integerDeserializer(), "follower_indices_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Ccr> {
        private Integer autoFollowPatternsCount;
        private Integer followerIndicesCount;

        public final Builder autoFollowPatternsCount(int value) {
            this.autoFollowPatternsCount = value;
            return this;
        }

        public final Builder followerIndicesCount(int value) {
            this.followerIndicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ccr build() {
            this._checkSingleUse();
            return new Ccr(this);
        }
    }
}

