/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class BackoffPolicy
implements Iterable<Long> {
    private static final BackoffPolicy NO_BACKOFF = new NoBackoff();

    public static BackoffPolicy noBackoff() {
        return NO_BACKOFF;
    }

    public static BackoffPolicy constantBackoff(Long delay, int maxNumberOfRetries) {
        return new ConstantBackoff(BackoffPolicy.checkDelay(delay), maxNumberOfRetries);
    }

    public static BackoffPolicy exponentialBackoff() {
        return BackoffPolicy.exponentialBackoff(50L, 8);
    }

    public static BackoffPolicy exponentialBackoff(Long initialDelay, int maxNumberOfRetries) {
        return new ExponentialBackoff(BackoffPolicy.checkDelay(initialDelay), maxNumberOfRetries);
    }

    public static BackoffPolicy linearBackoff(Long delayIncrement, int maxNumberOfRetries, Long maximumDelay) {
        return new LinearBackoff(delayIncrement, maxNumberOfRetries, maximumDelay);
    }

    public static BackoffPolicy wrap(BackoffPolicy delegate, Runnable onBackoff) {
        return new WrappedBackoffPolicy(delegate, onBackoff);
    }

    private static Long checkDelay(Long delay) {
        if (delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("delay must be <= 2147483647 ms");
        }
        return delay;
    }

    private static final class ConstantBackoff
    extends BackoffPolicy {
        private final Long delay;
        private final int numberOfElements;

        ConstantBackoff(Long delay, int numberOfElements) {
            assert (numberOfElements >= 0);
            this.delay = delay;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public Iterator<Long> iterator() {
            return new ConstantBackoffIterator(this.delay, this.numberOfElements);
        }

        public String toString() {
            return "ConstantBackoff{delay=" + this.delay + ", numberOfElements=" + this.numberOfElements + '}';
        }
    }

    private static class ExponentialBackoff
    extends BackoffPolicy {
        private final Long start;
        private final int numberOfElements;

        private ExponentialBackoff(Long start, int numberOfElements) {
            assert (start >= 0L);
            assert (numberOfElements >= 0);
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public Iterator<Long> iterator() {
            return new ExponentialBackoffIterator(this.start, this.numberOfElements);
        }

        public String toString() {
            return "ExponentialBackoff{start=" + this.start + ", numberOfElements=" + this.numberOfElements + '}';
        }
    }

    private static final class LinearBackoff
    extends BackoffPolicy {
        private final Long delayIncrement;
        private final int maxNumberOfRetries;
        private final Long maximumDelay;

        private LinearBackoff(Long delayIncrement, int maxNumberOfRetries, @Nullable Long maximumDelay) {
            this.delayIncrement = delayIncrement;
            this.maxNumberOfRetries = maxNumberOfRetries;
            this.maximumDelay = maximumDelay;
        }

        @Override
        public Iterator<Long> iterator() {
            return new LinearBackoffIterator(this.delayIncrement, this.maxNumberOfRetries, this.maximumDelay);
        }

        public String toString() {
            return "LinearBackoff{delayIncrement=" + this.delayIncrement + ", maxNumberOfRetries=" + this.maxNumberOfRetries + ", maximumDelay=" + this.maximumDelay + '}';
        }
    }

    private static final class WrappedBackoffPolicy
    extends BackoffPolicy {
        private final BackoffPolicy delegate;
        private final Runnable onBackoff;

        WrappedBackoffPolicy(BackoffPolicy delegate, Runnable onBackoff) {
            this.delegate = delegate;
            this.onBackoff = onBackoff;
        }

        @Override
        public Iterator<Long> iterator() {
            return new WrappedBackoffIterator(this.delegate.iterator(), this.onBackoff);
        }

        public String toString() {
            return "WrappedBackoffPolicy{delegate=" + this.delegate + ", onBackoff=" + this.onBackoff + '}';
        }
    }

    private static class NoBackoff
    extends BackoffPolicy {
        private NoBackoff() {
        }

        @Override
        public Iterator<Long> iterator() {
            return Collections.emptyIterator();
        }

        public String toString() {
            return "NoBackoff";
        }
    }

    private static final class LinearBackoffIterator
    implements Iterator<Long> {
        private final Long delayIncrement;
        private final int maxNumberOfRetries;
        private final Long maximumDelay;
        private int curr;

        private LinearBackoffIterator(Long delayIncrement, int maxNumberOfRetries, @Nullable Long maximumDelay) {
            this.delayIncrement = delayIncrement;
            this.maxNumberOfRetries = maxNumberOfRetries;
            this.maximumDelay = maximumDelay;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.maxNumberOfRetries;
        }

        @Override
        public Long next() {
            ++this.curr;
            Long Long2 = (long)this.curr * this.delayIncrement;
            return this.maximumDelay == null ? Long2 : (Long2.compareTo(this.maximumDelay) < 0 ? Long2 : this.maximumDelay);
        }
    }

    private static final class WrappedBackoffIterator
    implements Iterator<Long> {
        private final Iterator<Long> delegate;
        private final Runnable onBackoff;

        WrappedBackoffIterator(Iterator<Long> delegate, Runnable onBackoff) {
            this.delegate = delegate;
            this.onBackoff = onBackoff;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Long next() {
            if (!this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            this.onBackoff.run();
            return this.delegate.next();
        }
    }

    private static final class ConstantBackoffIterator
    implements Iterator<Long> {
        private final Long delay;
        private final int numberOfElements;
        private int curr;

        ConstantBackoffIterator(Long delay, int numberOfElements) {
            this.delay = delay;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.numberOfElements;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.curr;
            return this.delay;
        }
    }

    private static class ExponentialBackoffIterator
    implements Iterator<Long> {
        private final int numberOfElements;
        private final Long start;
        private int currentlyConsumed;

        private ExponentialBackoffIterator(Long start, int numberOfElements) {
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.currentlyConsumed < this.numberOfElements;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Only up to " + this.numberOfElements + " elements");
            }
            Long result = this.start + 10L * (long)((int)Math.exp(0.8 * (double)this.currentlyConsumed) - 1);
            ++this.currentlyConsumed;
            return result;
        }
    }
}

