/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.SlicesCalculation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Slices
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Slices> _DESERIALIZER = JsonpDeserializer.lazy(Slices::buildSlicesDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Slices(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Computed: {
                return this.computed().jsonValue();
            }
            case Value: {
                return String.valueOf(this.value());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private Slices(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Slices of(Function<Builder, ObjectBuilder<Slices>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isComputed() {
        return this._kind == Kind.Computed;
    }

    public SlicesCalculation computed() {
        return (SlicesCalculation)TaggedUnionUtils.get(this, Kind.Computed);
    }

    public boolean isValue() {
        return this._kind == Kind.Value;
    }

    public Integer value() {
        return (Integer)TaggedUnionUtils.get(this, Kind.Value);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Value: {
                    generator.write(((Integer)this._value).intValue());
                }
            }
        }
    }

    private static JsonpDeserializer<Slices> buildSlicesDeserializer() {
        return new UnionDeserializer.Builder<Slices, Kind, Object>(Slices::new, false).addMember(Kind.Computed, SlicesCalculation._DESERIALIZER).addMember(Kind.Value, JsonpDeserializer.integerDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Slices> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Slices> computed(SlicesCalculation v) {
            this._kind = Kind.Computed;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Slices> value(Integer v) {
            this._kind = Kind.Value;
            this._value = v;
            return this;
        }

        @Override
        public Slices build() {
            this._checkSingleUse();
            return new Slices(this);
        }
    }

    public static enum Kind {
        Computed,
        Value;

    }
}

