/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class HighlightBase
implements JsonpSerializable {
    @Nullable
    private final String type;
    @Nullable
    private final String boundaryChars;
    @Nullable
    private final Integer boundaryMaxScan;
    @Nullable
    private final BoundaryScanner boundaryScanner;
    @Nullable
    private final String boundaryScannerLocale;
    @Nullable
    private final Boolean forceSource;
    @Nullable
    private final HighlighterFragmenter fragmenter;
    @Nullable
    private final Integer fragmentSize;
    @Nullable
    private final Boolean highlightFilter;
    @Nullable
    private final Query highlightQuery;
    @Nullable
    private final Integer maxFragmentLength;
    @Nullable
    private final Integer maxAnalyzedOffset;
    @Nullable
    private final Integer noMatchSize;
    @Nullable
    private final Integer numberOfFragments;
    private final Map<String, JsonData> options;
    @Nullable
    private final HighlighterOrder order;
    @Nullable
    private final Integer phraseLimit;
    private final List<String> postTags;
    private final List<String> preTags;
    @Nullable
    private final Boolean requireFieldMatch;
    @Nullable
    private final HighlighterTagsSchema tagsSchema;

    protected HighlightBase(AbstractBuilder<?> builder) {
        this.type = ((AbstractBuilder)builder).type;
        this.boundaryChars = ((AbstractBuilder)builder).boundaryChars;
        this.boundaryMaxScan = ((AbstractBuilder)builder).boundaryMaxScan;
        this.boundaryScanner = ((AbstractBuilder)builder).boundaryScanner;
        this.boundaryScannerLocale = ((AbstractBuilder)builder).boundaryScannerLocale;
        this.forceSource = ((AbstractBuilder)builder).forceSource;
        this.fragmenter = ((AbstractBuilder)builder).fragmenter;
        this.fragmentSize = ((AbstractBuilder)builder).fragmentSize;
        this.highlightFilter = ((AbstractBuilder)builder).highlightFilter;
        this.highlightQuery = ((AbstractBuilder)builder).highlightQuery;
        this.maxFragmentLength = ((AbstractBuilder)builder).maxFragmentLength;
        this.maxAnalyzedOffset = ((AbstractBuilder)builder).maxAnalyzedOffset;
        this.noMatchSize = ((AbstractBuilder)builder).noMatchSize;
        this.numberOfFragments = ((AbstractBuilder)builder).numberOfFragments;
        this.options = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).options);
        this.order = ((AbstractBuilder)builder).order;
        this.phraseLimit = ((AbstractBuilder)builder).phraseLimit;
        this.postTags = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).postTags);
        this.preTags = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).preTags);
        this.requireFieldMatch = ((AbstractBuilder)builder).requireFieldMatch;
        this.tagsSchema = ((AbstractBuilder)builder).tagsSchema;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final String boundaryChars() {
        return this.boundaryChars;
    }

    @Nullable
    public final Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    @Nullable
    public final BoundaryScanner boundaryScanner() {
        return this.boundaryScanner;
    }

    @Nullable
    public final String boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Nullable
    public final Boolean forceSource() {
        return this.forceSource;
    }

    @Nullable
    public final HighlighterFragmenter fragmenter() {
        return this.fragmenter;
    }

    @Nullable
    public final Integer fragmentSize() {
        return this.fragmentSize;
    }

    @Nullable
    public final Boolean highlightFilter() {
        return this.highlightFilter;
    }

    @Nullable
    public final Query highlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public final Integer maxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Nullable
    public final Integer maxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    @Nullable
    public final Integer noMatchSize() {
        return this.noMatchSize;
    }

    @Nullable
    public final Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    public final Map<String, JsonData> options() {
        return this.options;
    }

    @Nullable
    public final HighlighterOrder order() {
        return this.order;
    }

    @Nullable
    public final Integer phraseLimit() {
        return this.phraseLimit;
    }

    public final List<String> postTags() {
        return this.postTags;
    }

    public final List<String> preTags() {
        return this.preTags;
    }

    @Nullable
    public final Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    @Nullable
    public final HighlighterTagsSchema tagsSchema() {
        return this.tagsSchema;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
        if (this.boundaryChars != null) {
            generator.writeKey("boundary_chars");
            generator.write(this.boundaryChars);
        }
        if (this.boundaryMaxScan != null) {
            generator.writeKey("boundary_max_scan");
            generator.write(this.boundaryMaxScan.intValue());
        }
        if (this.boundaryScanner != null) {
            generator.writeKey("boundary_scanner");
            this.boundaryScanner.serialize(generator, mapper);
        }
        if (this.boundaryScannerLocale != null) {
            generator.writeKey("boundary_scanner_locale");
            generator.write(this.boundaryScannerLocale);
        }
        if (this.forceSource != null) {
            generator.writeKey("force_source");
            generator.write(this.forceSource.booleanValue());
        }
        if (this.fragmenter != null) {
            generator.writeKey("fragmenter");
            this.fragmenter.serialize(generator, mapper);
        }
        if (this.fragmentSize != null) {
            generator.writeKey("fragment_size");
            generator.write(this.fragmentSize.intValue());
        }
        if (this.highlightFilter != null) {
            generator.writeKey("highlight_filter");
            generator.write(this.highlightFilter.booleanValue());
        }
        if (this.highlightQuery != null) {
            generator.writeKey("highlight_query");
            this.highlightQuery.serialize(generator, mapper);
        }
        if (this.maxFragmentLength != null) {
            generator.writeKey("max_fragment_length");
            generator.write(this.maxFragmentLength.intValue());
        }
        if (this.maxAnalyzedOffset != null) {
            generator.writeKey("max_analyzed_offset");
            generator.write(this.maxAnalyzedOffset.intValue());
        }
        if (this.noMatchSize != null) {
            generator.writeKey("no_match_size");
            generator.write(this.noMatchSize.intValue());
        }
        if (this.numberOfFragments != null) {
            generator.writeKey("number_of_fragments");
            generator.write(this.numberOfFragments.intValue());
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.options.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.phraseLimit != null) {
            generator.writeKey("phrase_limit");
            generator.write(this.phraseLimit.intValue());
        }
        if (ApiTypeHelper.isDefined(this.postTags)) {
            generator.writeKey("post_tags");
            generator.writeStartArray();
            for (String string : this.postTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.preTags)) {
            generator.writeKey("pre_tags");
            generator.writeStartArray();
            for (String string : this.preTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.requireFieldMatch != null) {
            generator.writeKey("require_field_match");
            generator.write(this.requireFieldMatch.booleanValue());
        }
        if (this.tagsSchema != null) {
            generator.writeKey("tags_schema");
            this.tagsSchema.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupHighlightBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(AbstractBuilder::boundaryChars, JsonpDeserializer.stringDeserializer(), "boundary_chars");
        op.add(AbstractBuilder::boundaryMaxScan, JsonpDeserializer.integerDeserializer(), "boundary_max_scan");
        op.add(AbstractBuilder::boundaryScanner, BoundaryScanner._DESERIALIZER, "boundary_scanner");
        op.add(AbstractBuilder::boundaryScannerLocale, JsonpDeserializer.stringDeserializer(), "boundary_scanner_locale");
        op.add(AbstractBuilder::forceSource, JsonpDeserializer.booleanDeserializer(), "force_source");
        op.add(AbstractBuilder::fragmenter, HighlighterFragmenter._DESERIALIZER, "fragmenter");
        op.add(AbstractBuilder::fragmentSize, JsonpDeserializer.integerDeserializer(), "fragment_size");
        op.add(AbstractBuilder::highlightFilter, JsonpDeserializer.booleanDeserializer(), "highlight_filter");
        op.add(AbstractBuilder::highlightQuery, Query._DESERIALIZER, "highlight_query");
        op.add(AbstractBuilder::maxFragmentLength, JsonpDeserializer.integerDeserializer(), "max_fragment_length");
        op.add(AbstractBuilder::maxAnalyzedOffset, JsonpDeserializer.integerDeserializer(), "max_analyzed_offset");
        op.add(AbstractBuilder::noMatchSize, JsonpDeserializer.integerDeserializer(), "no_match_size");
        op.add(AbstractBuilder::numberOfFragments, JsonpDeserializer.integerDeserializer(), "number_of_fragments");
        op.add(AbstractBuilder::options, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "options");
        op.add(AbstractBuilder::order, HighlighterOrder._DESERIALIZER, "order");
        op.add(AbstractBuilder::phraseLimit, JsonpDeserializer.integerDeserializer(), "phrase_limit");
        op.add(AbstractBuilder::postTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "post_tags");
        op.add(AbstractBuilder::preTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pre_tags");
        op.add(AbstractBuilder::requireFieldMatch, JsonpDeserializer.booleanDeserializer(), "require_field_match");
        op.add(AbstractBuilder::tagsSchema, HighlighterTagsSchema._DESERIALIZER, "tags_schema");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String type;
        @Nullable
        private String boundaryChars;
        @Nullable
        private Integer boundaryMaxScan;
        @Nullable
        private BoundaryScanner boundaryScanner;
        @Nullable
        private String boundaryScannerLocale;
        @Nullable
        private Boolean forceSource;
        @Nullable
        private HighlighterFragmenter fragmenter;
        @Nullable
        private Integer fragmentSize;
        @Nullable
        private Boolean highlightFilter;
        @Nullable
        private Query highlightQuery;
        @Nullable
        private Integer maxFragmentLength;
        @Nullable
        private Integer maxAnalyzedOffset;
        @Nullable
        private Integer noMatchSize;
        @Nullable
        private Integer numberOfFragments;
        @Nullable
        private Map<String, JsonData> options;
        @Nullable
        private HighlighterOrder order;
        @Nullable
        private Integer phraseLimit;
        @Nullable
        private List<String> postTags;
        @Nullable
        private List<String> preTags;
        @Nullable
        private Boolean requireFieldMatch;
        @Nullable
        private HighlighterTagsSchema tagsSchema;

        protected AbstractBuilder() {
        }

        public final BuilderT type(@Nullable String value) {
            this.type = value;
            return (BuilderT)this.self();
        }

        public final BuilderT type(@Nullable HighlighterType value) {
            this.type = value == null ? null : value.jsonValue();
            return (BuilderT)this.self();
        }

        public final BuilderT boundaryChars(@Nullable String value) {
            this.boundaryChars = value;
            return (BuilderT)this.self();
        }

        public final BuilderT boundaryMaxScan(@Nullable Integer value) {
            this.boundaryMaxScan = value;
            return (BuilderT)this.self();
        }

        public final BuilderT boundaryScanner(@Nullable BoundaryScanner value) {
            this.boundaryScanner = value;
            return (BuilderT)this.self();
        }

        public final BuilderT boundaryScannerLocale(@Nullable String value) {
            this.boundaryScannerLocale = value;
            return (BuilderT)this.self();
        }

        public final BuilderT forceSource(@Nullable Boolean value) {
            this.forceSource = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fragmenter(@Nullable HighlighterFragmenter value) {
            this.fragmenter = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fragmentSize(@Nullable Integer value) {
            this.fragmentSize = value;
            return (BuilderT)this.self();
        }

        public final BuilderT highlightFilter(@Nullable Boolean value) {
            this.highlightFilter = value;
            return (BuilderT)this.self();
        }

        public final BuilderT highlightQuery(@Nullable Query value) {
            this.highlightQuery = value;
            return (BuilderT)this.self();
        }

        public final BuilderT highlightQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.highlightQuery(fn.apply(new Query.Builder()).build());
        }

        public final BuilderT maxFragmentLength(@Nullable Integer value) {
            this.maxFragmentLength = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxAnalyzedOffset(@Nullable Integer value) {
            this.maxAnalyzedOffset = value;
            return (BuilderT)this.self();
        }

        public final BuilderT noMatchSize(@Nullable Integer value) {
            this.noMatchSize = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numberOfFragments(@Nullable Integer value) {
            this.numberOfFragments = value;
            return (BuilderT)this.self();
        }

        public final BuilderT options(Map<String, JsonData> map) {
            this.options = AbstractBuilder._mapPutAll(this.options, map);
            return (BuilderT)this.self();
        }

        public final BuilderT options(String key, JsonData value) {
            this.options = AbstractBuilder._mapPut(this.options, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT order(@Nullable HighlighterOrder value) {
            this.order = value;
            return (BuilderT)this.self();
        }

        public final BuilderT phraseLimit(@Nullable Integer value) {
            this.phraseLimit = value;
            return (BuilderT)this.self();
        }

        public final BuilderT postTags(List<String> list) {
            this.postTags = AbstractBuilder._listAddAll(this.postTags, list);
            return (BuilderT)this.self();
        }

        public final BuilderT postTags(String value, String ... values) {
            this.postTags = AbstractBuilder._listAdd(this.postTags, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT preTags(List<String> list) {
            this.preTags = AbstractBuilder._listAddAll(this.preTags, list);
            return (BuilderT)this.self();
        }

        public final BuilderT preTags(String value, String ... values) {
            this.preTags = AbstractBuilder._listAdd(this.preTags, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT requireFieldMatch(@Nullable Boolean value) {
            this.requireFieldMatch = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tagsSchema(@Nullable HighlighterTagsSchema value) {
            this.tagsSchema = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

