/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.Level;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.IndicesStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class IndicesStatsRequest
extends RequestBase {
    private final List<String> completionFields;
    private final List<ExpandWildcard> expandWildcards;
    private final List<String> fielddataFields;
    private final List<String> fields;
    @Nullable
    private final Boolean forbidClosedIndices;
    private final List<String> groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nullable
    private final Boolean includeUnloadedSegments;
    private final List<String> index;
    @Nullable
    private final Level level;
    private final List<String> metric;
    public static final Endpoint<IndicesStatsRequest, IndicesStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndicesStatsRequest, IndicesStatsResponse>("es/indices.stats", request -> "GET", request -> {
        boolean _metric = true;
        int _index = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.level != null) {
            params.put("level", request.level.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.completionFields)) {
            params.put("completion_fields", request.completionFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.fielddataFields)) {
            params.put("fielddata_fields", request.fielddataFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.groups)) {
            params.put("groups", request.groups.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (ApiTypeHelper.isDefined(request.fields)) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.forbidClosedIndices != null) {
            params.put("forbid_closed_indices", String.valueOf(request.forbidClosedIndices));
        }
        if (request.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(request.includeSegmentFileSizes));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, IndicesStatsResponse._DESERIALIZER);

    private IndicesStatsRequest(Builder builder) {
        this.completionFields = ApiTypeHelper.unmodifiable(builder.completionFields);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.fielddataFields = ApiTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.forbidClosedIndices = builder.forbidClosedIndices;
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.level = builder.level;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
    }

    public static IndicesStatsRequest of(Function<Builder, ObjectBuilder<IndicesStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> completionFields() {
        return this.completionFields;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    public final List<String> fielddataFields() {
        return this.fielddataFields;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean forbidClosedIndices() {
        return this.forbidClosedIndices;
    }

    public final List<String> groups() {
        return this.groups;
    }

    @Nullable
    public final Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Level level() {
        return this.level;
    }

    public final List<String> metric() {
        return this.metric;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndicesStatsRequest> {
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean forbidClosedIndices;
        @Nullable
        private List<String> groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<String> index;
        @Nullable
        private Level level;
        @Nullable
        private List<String> metric;

        public final Builder completionFields(List<String> list) {
            this.completionFields = Builder._listAddAll(this.completionFields, list);
            return this;
        }

        public final Builder completionFields(String value, String ... values) {
            this.completionFields = Builder._listAdd(this.completionFields, value, values);
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder fielddataFields(List<String> list) {
            this.fielddataFields = Builder._listAddAll(this.fielddataFields, list);
            return this;
        }

        public final Builder fielddataFields(String value, String ... values) {
            this.fielddataFields = Builder._listAdd(this.fielddataFields, value, values);
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder forbidClosedIndices(@Nullable Boolean value) {
            this.forbidClosedIndices = value;
            return this;
        }

        public final Builder groups(List<String> list) {
            this.groups = Builder._listAddAll(this.groups, list);
            return this;
        }

        public final Builder groups(String value, String ... values) {
            this.groups = Builder._listAdd(this.groups, value, values);
            return this;
        }

        public final Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        public final Builder metric(List<String> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(String value, String ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Override
        public IndicesStatsRequest build() {
            this._checkSingleUse();
            return new IndicesStatsRequest(this);
        }
    }
}

