/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetInfluencersResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetInfluencersRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean desc;
    @Nullable
    private final DateTime end;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Integer from;
    @Nullable
    private final Double influencerScore;
    private final String jobId;
    @Nullable
    private final Page page;
    @Nullable
    private final Integer size;
    @Nullable
    private final String sort;
    @Nullable
    private final DateTime start;
    public static final JsonpDeserializer<GetInfluencersRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetInfluencersRequest::setupGetInfluencersRequestDeserializer);
    public static final Endpoint<GetInfluencersRequest, GetInfluencersResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetInfluencersRequest, GetInfluencersResponse>("es/ml.get_influencers", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/influencers");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.excludeInterim != null) {
            params.put("exclude_interim", String.valueOf(request.excludeInterim));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.start != null) {
            params.put("start", request.start.toString());
        }
        if (request.end != null) {
            params.put("end", request.end.toString());
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.sort != null) {
            params.put("sort", request.sort);
        }
        if (request.influencerScore != null) {
            params.put("influencer_score", String.valueOf(request.influencerScore));
        }
        if (request.desc != null) {
            params.put("desc", String.valueOf(request.desc));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetInfluencersResponse._DESERIALIZER);

    private GetInfluencersRequest(Builder builder) {
        this.desc = builder.desc;
        this.end = builder.end;
        this.excludeInterim = builder.excludeInterim;
        this.from = builder.from;
        this.influencerScore = builder.influencerScore;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.page = builder.page;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
    }

    public static GetInfluencersRequest of(Function<Builder, ObjectBuilder<GetInfluencersRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean desc() {
        return this.desc;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Double influencerScore() {
        return this.influencerScore;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String sort() {
        return this.sort;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetInfluencersRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetInfluencersRequest> {
        @Nullable
        private Boolean desc;
        @Nullable
        private DateTime end;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Integer from;
        @Nullable
        private Double influencerScore;
        private String jobId;
        @Nullable
        private Page page;
        @Nullable
        private Integer size;
        @Nullable
        private String sort;
        @Nullable
        private DateTime start;

        public final Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder influencerScore(@Nullable Double value) {
            this.influencerScore = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetInfluencersRequest build() {
            this._checkSingleUse();
            return new GetInfluencersRequest(this);
        }
    }
}

