/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.GetMemoryStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetMemoryStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean human;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<GetMemoryStatsRequest, GetMemoryStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetMemoryStatsRequest, GetMemoryStatsResponse>("es/ml.get_memory_stats", request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/memory");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/memory");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.human != null) {
            params.put("human", String.valueOf(request.human));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetMemoryStatsResponse._DESERIALIZER);

    private GetMemoryStatsRequest(Builder builder) {
        this.human = builder.human;
        this.masterTimeout = builder.masterTimeout;
        this.nodeId = builder.nodeId;
        this.timeout = builder.timeout;
    }

    public static GetMemoryStatsRequest of(Function<Builder, ObjectBuilder<GetMemoryStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean human() {
        return this.human;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetMemoryStatsRequest> {
        @Nullable
        private Boolean human;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String nodeId;
        @Nullable
        private Time timeout;

        public final Builder human(@Nullable Boolean value) {
            this.human = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public GetMemoryStatsRequest build() {
            this._checkSingleUse();
            return new GetMemoryStatsRequest(this);
        }
    }
}

