/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.UpdateUserProfileDataResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateUserProfileDataRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> access;
    private final Map<String, JsonData> data;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    @Nullable
    private final Refresh refresh;
    private final String uid;
    public static final JsonpDeserializer<UpdateUserProfileDataRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateUserProfileDataRequest::setupUpdateUserProfileDataRequestDeserializer);
    public static final Endpoint<UpdateUserProfileDataRequest, UpdateUserProfileDataResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateUserProfileDataRequest, UpdateUserProfileDataResponse>("es/security.update_user_profile_data", request -> "PUT", request -> {
        boolean _uid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/profile");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.uid, buf);
            buf.append("/_data");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateUserProfileDataResponse._DESERIALIZER);

    private UpdateUserProfileDataRequest(Builder builder) {
        this.access = ApiTypeHelper.unmodifiable(builder.access);
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.refresh = builder.refresh;
        this.uid = ApiTypeHelper.requireNonNull(builder.uid, this, "uid");
    }

    public static UpdateUserProfileDataRequest of(Function<Builder, ObjectBuilder<UpdateUserProfileDataRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> access() {
        return this.access;
    }

    public final Map<String, JsonData> data() {
        return this.data;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final String uid() {
        return this.uid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.access)) {
            generator.writeKey("access");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.access.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.data.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateUserProfileDataRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::access, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "access");
        op.add(Builder::data, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "data");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UpdateUserProfileDataRequest> {
        @Nullable
        private Map<String, JsonData> access;
        @Nullable
        private Map<String, JsonData> data;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        @Nullable
        private Refresh refresh;
        private String uid;

        public final Builder access(Map<String, JsonData> map) {
            this.access = Builder._mapPutAll(this.access, map);
            return this;
        }

        public final Builder access(String key, JsonData value) {
            this.access = Builder._mapPut(this.access, key, value);
            return this;
        }

        public final Builder data(Map<String, JsonData> map) {
            this.data = Builder._mapPutAll(this.data, map);
            return this;
        }

        public final Builder data(String key, JsonData value) {
            this.data = Builder._mapPut(this.data, key, value);
            return this;
        }

        public final Builder ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder uid(String value) {
            this.uid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateUserProfileDataRequest build() {
            this._checkSingleUse();
            return new UpdateUserProfileDataRequest(this);
        }
    }
}

