/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.UserProfileUser;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserProfile
implements JsonpSerializable {
    private final String uid;
    private final UserProfileUser user;
    private final Map<String, JsonData> data;
    private final Map<String, JsonData> labels;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<UserProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserProfile::setupUserProfileDeserializer);

    protected UserProfile(AbstractBuilder<?> builder) {
        this.uid = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).uid, this, "uid");
        this.user = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).user, this, "user");
        this.data = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).data);
        this.labels = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).labels);
        this.enabled = ((AbstractBuilder)builder).enabled;
    }

    public static UserProfile userProfileOf(Function<Builder, ObjectBuilder<UserProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String uid() {
        return this.uid;
    }

    public final UserProfileUser user() {
        return this.user;
    }

    public final Map<String, JsonData> data() {
        return this.data;
    }

    public final Map<String, JsonData> labels() {
        return this.labels;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("uid");
        generator.write(this.uid);
        generator.writeKey("user");
        this.user.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.data.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.labels)) {
            generator.writeKey("labels");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.labels.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupUserProfileDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::uid, JsonpDeserializer.stringDeserializer(), "uid");
        op.add(AbstractBuilder::user, UserProfileUser._DESERIALIZER, "user");
        op.add(AbstractBuilder::data, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "data");
        op.add(AbstractBuilder::labels, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "labels");
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String uid;
        private UserProfileUser user;
        @Nullable
        private Map<String, JsonData> data;
        @Nullable
        private Map<String, JsonData> labels;
        @Nullable
        private Boolean enabled;

        protected AbstractBuilder() {
        }

        public final BuilderT uid(String value) {
            this.uid = value;
            return (BuilderT)this.self();
        }

        public final BuilderT user(UserProfileUser value) {
            this.user = value;
            return (BuilderT)this.self();
        }

        public final BuilderT user(Function<UserProfileUser.Builder, ObjectBuilder<UserProfileUser>> fn) {
            return this.user(fn.apply(new UserProfileUser.Builder()).build());
        }

        public final BuilderT data(Map<String, JsonData> map) {
            this.data = AbstractBuilder._mapPutAll(this.data, map);
            return (BuilderT)this.self();
        }

        public final BuilderT data(String key, JsonData value) {
            this.data = AbstractBuilder._mapPut(this.data, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT labels(Map<String, JsonData> map) {
            this.labels = AbstractBuilder._mapPutAll(this.labels, map);
            return (BuilderT)this.self();
        }

        public final BuilderT labels(String key, JsonData value) {
            this.labels = AbstractBuilder._mapPut(this.labels, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT enabled(@Nullable Boolean value) {
            this.enabled = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<UserProfile> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserProfile build() {
            this._checkSingleUse();
            return new UserProfile(this);
        }
    }
}

