/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformProgress;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CheckpointStats
implements JsonpSerializable {
    private final long checkpoint;
    @Nullable
    private final TransformProgress checkpointProgress;
    @Nullable
    private final DateTime timestamp;
    @Nullable
    private final DateTime timestampMillis;
    @Nullable
    private final DateTime timeUpperBound;
    @Nullable
    private final DateTime timeUpperBoundMillis;
    public static final JsonpDeserializer<CheckpointStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CheckpointStats::setupCheckpointStatsDeserializer);

    private CheckpointStats(Builder builder) {
        this.checkpoint = ApiTypeHelper.requireNonNull(builder.checkpoint, this, "checkpoint");
        this.checkpointProgress = builder.checkpointProgress;
        this.timestamp = builder.timestamp;
        this.timestampMillis = builder.timestampMillis;
        this.timeUpperBound = builder.timeUpperBound;
        this.timeUpperBoundMillis = builder.timeUpperBoundMillis;
    }

    public static CheckpointStats of(Function<Builder, ObjectBuilder<CheckpointStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long checkpoint() {
        return this.checkpoint;
    }

    @Nullable
    public final TransformProgress checkpointProgress() {
        return this.checkpointProgress;
    }

    @Nullable
    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final DateTime timestampMillis() {
        return this.timestampMillis;
    }

    @Nullable
    public final DateTime timeUpperBound() {
        return this.timeUpperBound;
    }

    @Nullable
    public final DateTime timeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("checkpoint");
        generator.write(this.checkpoint);
        if (this.checkpointProgress != null) {
            generator.writeKey("checkpoint_progress");
            this.checkpointProgress.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            this.timestamp.serialize(generator, mapper);
        }
        if (this.timestampMillis != null) {
            generator.writeKey("timestamp_millis");
            this.timestampMillis.serialize(generator, mapper);
        }
        if (this.timeUpperBound != null) {
            generator.writeKey("time_upper_bound");
            this.timeUpperBound.serialize(generator, mapper);
        }
        if (this.timeUpperBoundMillis != null) {
            generator.writeKey("time_upper_bound_millis");
            this.timeUpperBoundMillis.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCheckpointStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkpoint, JsonpDeserializer.longDeserializer(), "checkpoint");
        op.add(Builder::checkpointProgress, TransformProgress._DESERIALIZER, "checkpoint_progress");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
        op.add(Builder::timestampMillis, DateTime._DESERIALIZER, "timestamp_millis");
        op.add(Builder::timeUpperBound, DateTime._DESERIALIZER, "time_upper_bound");
        op.add(Builder::timeUpperBoundMillis, DateTime._DESERIALIZER, "time_upper_bound_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CheckpointStats> {
        private Long checkpoint;
        @Nullable
        private TransformProgress checkpointProgress;
        @Nullable
        private DateTime timestamp;
        @Nullable
        private DateTime timestampMillis;
        @Nullable
        private DateTime timeUpperBound;
        @Nullable
        private DateTime timeUpperBoundMillis;

        public final Builder checkpoint(long value) {
            this.checkpoint = value;
            return this;
        }

        public final Builder checkpointProgress(@Nullable TransformProgress value) {
            this.checkpointProgress = value;
            return this;
        }

        public final Builder checkpointProgress(Function<TransformProgress.Builder, ObjectBuilder<TransformProgress>> fn) {
            return this.checkpointProgress(fn.apply(new TransformProgress.Builder()).build());
        }

        public final Builder timestamp(@Nullable DateTime value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestampMillis(@Nullable DateTime value) {
            this.timestampMillis = value;
            return this;
        }

        public final Builder timeUpperBound(@Nullable DateTime value) {
            this.timeUpperBound = value;
            return this;
        }

        public final Builder timeUpperBoundMillis(@Nullable DateTime value) {
            this.timeUpperBoundMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CheckpointStats build() {
            this._checkSingleUse();
            return new CheckpointStats(this);
        }
    }
}

