/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.reporter;

import co.helmethair.scalatest.descriptor.ScalatestDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestSuiteDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestTestDescriptor;
import co.helmethair.scalatest.scala.OptionHelper;
import java.util.Collections;
import java.util.Optional;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.scalatest.Reporter;
import org.scalatest.Suite;
import org.scalatest.events.Event;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunStopped;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;

public class JUnitReporter
implements Reporter {
    private final EngineExecutionListener junitListener;
    private final TestDescriptor rootTestDescriptor;
    private volatile Throwable skipWithCause = null;

    public JUnitReporter(EngineExecutionListener junitListener, TestDescriptor rootTestDescriptor) {
        this.junitListener = junitListener;
        this.rootTestDescriptor = rootTestDescriptor;
    }

    public void apply(Event event) {
        if (event instanceof TestStarting) {
            TestStarting e = (TestStarting)event;
            this.junitListener.executionStarted(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), e.testName()));
        } else if (event instanceof TestCanceled) {
            TestCanceled e = (TestCanceled)event;
            this.junitListener.executionFinished(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), e.testName()), TestExecutionResult.aborted((Throwable)OptionHelper.getOrElse(e.throwable(), null)));
        } else if (event instanceof TestSucceeded) {
            TestSucceeded e = (TestSucceeded)event;
            this.junitListener.executionFinished(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), e.testName()), TestExecutionResult.successful());
        } else if (event instanceof TestFailed) {
            TestFailed e = (TestFailed)event;
            TestDescriptor descriptor = this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), e.testName());
            Throwable cause = OptionHelper.getOrElse(e.throwable(), null);
            this.setSkipWithCause(cause);
            this.junitListener.executionFinished(descriptor, TestExecutionResult.failed((Throwable)cause));
        } else if (event instanceof RunAborted) {
            RunAborted e = (RunAborted)event;
            Throwable ex = OptionHelper.getOrElse(e.throwable(), null);
            TestDescriptor testDescriptor = this.rootTestDescriptor;
            Object payload = e.payload().getOrElse(null);
            if (payload != null && payload instanceof Suite) {
                Suite s = (Suite)payload;
                testDescriptor = this.getOrCreateDescriptor(s.suiteId(), s.suiteName(), null);
            }
            this.junitListener.executionFinished(testDescriptor, TestExecutionResult.failed((Throwable)ex));
        } else if (event instanceof SuiteStarting) {
            SuiteStarting e = (SuiteStarting)event;
            this.junitListener.executionStarted(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), null));
        } else if (event instanceof SuiteAborted) {
            SuiteAborted e = (SuiteAborted)event;
            Throwable ex = OptionHelper.getOrElse(e.throwable(), null);
            TestDescriptor suiteDescriptor = this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), null);
            this.junitListener.executionFinished(suiteDescriptor, TestExecutionResult.failed((Throwable)ex));
        } else if (event instanceof SuiteCompleted) {
            SuiteCompleted e = (SuiteCompleted)event;
            this.junitListener.executionFinished(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), null), TestExecutionResult.successful());
        } else if (event instanceof RunStopped) {
            this.junitListener.executionFinished(this.rootTestDescriptor, TestExecutionResult.aborted(null));
        } else if (event instanceof RunCompleted) {
            this.junitListener.executionFinished(this.rootTestDescriptor, TestExecutionResult.successful());
        } else if (event instanceof TestIgnored) {
            TestIgnored e = (TestIgnored)event;
            this.junitListener.executionSkipped(this.getOrCreateDescriptor(e.suiteId(), e.suiteName(), e.testName()), "ignored");
        }
    }

    public Throwable getSkipWithCause() {
        return this.skipWithCause;
    }

    public void setSkipWithCause(Throwable skipWithCause) {
        this.skipWithCause = skipWithCause;
    }

    private TestDescriptor getOrCreateDescriptor(String suiteId, String suiteName, String testName) {
        Optional<ScalatestDescriptor> existingDescriptor = ScalatestDescriptor.find(suiteId, testName);
        return existingDescriptor.orElseGet(() -> {
            ScalatestSuiteDescriptor newDescriptor = null;
            if (testName != null) {
                ScalatestSuiteDescriptor suite = (ScalatestSuiteDescriptor)this.getOrCreateDescriptor(suiteId, suiteName, null);
                new ScalatestTestDescriptor(suite, testName, Collections.emptySet());
            } else {
                newDescriptor = new ScalatestSuiteDescriptor(null, suiteId, suiteName);
            }
            this.junitListener.dynamicTestRegistered((TestDescriptor)newDescriptor);
            return newDescriptor;
        });
    }

    public EngineExecutionListener getJunitListener() {
        return this.junitListener;
    }

    public TestDescriptor getRootTestDescriptor() {
        return this.rootTestDescriptor;
    }
}

