/*
 * Decompiled with CFR 0.152.
 */
package com.cognos;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerServiceStub;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ReportServiceStub;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SystemService_Port;
import com.cognos.developer.schemas.bibus._3.SystemService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;

public class CRNConnect {
    private ContentManagerService_ServiceLocator cmServiceLocator = null;
    private ReportService_ServiceLocator reportServiceLocator = null;
    private SystemService_ServiceLocator systemServiceLocator = null;
    private ContentManagerServiceStub cmService = null;
    private ReportServiceStub repService = null;
    private SystemService_Port sysService = null;
    private String CM_URL = "http://localhost:9300/p2pd/servlet/dispatch";
    private String username = null;
    private String pwd = null;
    private String namespace = null;
    private boolean isused = false;
    private long lastUse = 0L;

    public boolean isUsed() {
        return this.isused;
    }

    public void setUsed(boolean isused) {
        this.isused = isused;
    }

    public boolean isTimeOut() {
        return System.currentTimeMillis() - this.lastUse > 300000L;
    }

    public CRNConnect(String CM_URL, String username, String pwd, String namesapce) {
        this.CM_URL = CM_URL;
        this.username = username;
        this.pwd = pwd;
        this.namespace = namesapce;
        this.connectToCognosServer();
    }

    public CRNConnect(String CM_URL, String passport) {
        this.CM_URL = CM_URL;
        this.setPassPort(passport);
    }

    public void release() {
        this.setUsed(false);
        this.lastUse = System.currentTimeMillis();
    }

    public ContentManagerServiceStub connectToCognosServer() {
        BiBusHeader bibus = null;
        while (bibus == null) {
            this.cmServiceLocator = new ContentManagerService_ServiceLocator();
            this.reportServiceLocator = new ReportService_ServiceLocator();
            this.systemServiceLocator = new SystemService_ServiceLocator();
            try {
                URL serverURL = new URL(this.CM_URL);
                this.cmService = new ContentManagerServiceStub(serverURL, (Service)this.cmServiceLocator);
                this.repService = new ReportServiceStub(serverURL, (Service)this.reportServiceLocator);
                this.sysService = this.systemServiceLocator.getsystemService(serverURL);
                this.cmService.setTimeout(0);
                this.repService.setTimeout(0);
            }
            catch (MalformedURLException e) {
                System.out.println("Malformed URL:\n" + e.getMessage());
                return null;
            }
            catch (ServiceException e) {
                System.out.println("Service Exception:\n" + e.getMessage());
                return null;
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
            try {
                this.quickLogon();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                System.out.println(e.toString());
                return null;
            }
            bibus = (BiBusHeader)this.cmService.getHeaderObject("", "biBusHeader");
            if (bibus == null) continue;
            return this.cmService;
        }
        return null;
    }

    private ContentManagerServiceStub setPassPort(String CamPassport) {
        BiBusHeader bibus = null;
        while (bibus == null) {
            this.cmServiceLocator = new ContentManagerService_ServiceLocator();
            this.reportServiceLocator = new ReportService_ServiceLocator();
            this.systemServiceLocator = new SystemService_ServiceLocator();
            try {
                URL serverURL = new URL(this.CM_URL);
                this.cmService = new ContentManagerServiceStub(serverURL, (Service)this.cmServiceLocator);
                this.repService = new ReportServiceStub(serverURL, (Service)this.reportServiceLocator);
                this.sysService = this.systemServiceLocator.getsystemService(serverURL);
                this.cmService.setTimeout(0);
                this.repService.setTimeout(0);
            }
            catch (MalformedURLException e) {
                System.out.println("Malformed URL:\n" + e.getMessage());
                return null;
            }
            catch (ServiceException e) {
                System.out.println("Service Exception:\n" + e.getMessage());
                return null;
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
            bibus = new BiBusHeader();
            CAM cam = new CAM();
            CAMPassport camPass = new CAMPassport();
            camPass.setId(CamPassport);
            cam.setCAMPassport(camPass);
            bibus.setCAM(cam);
            this.cmService.setHeader("", "biBusHeader", (Object)bibus);
            if (bibus == null) continue;
            return this.cmService;
        }
        return null;
    }

    public ContentManagerServiceStub getCMService() {
        return this.cmService;
    }

    public ReportServiceStub getReportService() {
        BiBusHeader bibus = null;
        bibus = (BiBusHeader)this.repService.getHeaderObject("", "biBusHeader");
        if (bibus == null) {
            BiBusHeader CMbibus = null;
            CMbibus = (BiBusHeader)this.cmService.getHeaderObject("", "biBusHeader");
            this.repService.setHeader("", "biBusHeader", (Object)CMbibus);
        }
        return this.repService;
    }

    public SystemService_Port getSystemService() {
        BiBusHeader bibus = null;
        bibus = (BiBusHeader)((Stub)this.sysService).getHeaderObject("", "biBusHeader");
        if (bibus == null) {
            BiBusHeader CMbibus = null;
            CMbibus = (BiBusHeader)this.cmService.getHeaderObject("", "biBusHeader");
            ((Stub)this.sysService).setHeader("", "biBusHeader", (Object)CMbibus);
        }
        return this.sysService;
    }

    public void quickLogon() throws RemoteException {
        StringBuffer credentialXML = new StringBuffer();
        credentialXML.append("<credential>");
        credentialXML.append("<namespace>");
        credentialXML.append(this.namespace == null ? "" : this.namespace);
        credentialXML.append("</namespace>");
        credentialXML.append("<username>");
        credentialXML.append(this.username == null ? "" : this.username);
        credentialXML.append("</username>");
        credentialXML.append("<password>");
        credentialXML.append(this.pwd == null ? "" : this.pwd);
        credentialXML.append("</password>");
        credentialXML.append("</credential>");
        String encodedCredentials = credentialXML.toString();
        this.getCMService().logon(new XmlEncodedXML(encodedCredentials), new SearchPathSingleObject[0]);
    }

    public String getPassPort() {
        BiBusHeader bibus = null;
        String passport = null;
        try {
            bibus = (BiBusHeader)this.getCMService().getHeaderObject("", "biBusHeader");
            passport = bibus.getCAM().getCAMPassport().getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return passport;
    }

    public BiBusHeader getBiBus() {
        BiBusHeader bibus = null;
        try {
            bibus = (BiBusHeader)this.getCMService().getHeaderObject("", "biBusHeader");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bibus;
    }

    public static void main(String[] args) {
        String CM_URL = "http://localhost:9304/p2pd/servlet/dispatch";
        String name = "admin";
        String pass = "admin1234";
        String CM_namespace = "dbAuth";
        CRNConnect connect = new CRNConnect(CM_URL, name, pass, CM_namespace);
        String passport = connect.getPassPort();
    }
}

