/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeContext {
    public ChainNode currentNode;
    public ChainNode prevNode;
    public String fromEdgeId;
    private AtomicInteger triggerCount = new AtomicInteger(0);
    private List<String> triggerEdgeIds = new ArrayList<String>();
    private AtomicInteger executeCount = new AtomicInteger(0);
    private List<String> executeEdgeIds = new ArrayList<String>();

    public ChainNode getCurrentNode() {
        return this.currentNode;
    }

    public ChainNode getPrevNode() {
        return this.prevNode;
    }

    public String getFromEdgeId() {
        return this.fromEdgeId;
    }

    public int getTriggerCount() {
        return this.triggerCount.get();
    }

    public List<String> getTriggerEdgeIds() {
        return this.triggerEdgeIds;
    }

    public int getExecuteCount() {
        return this.executeCount.get();
    }

    public List<String> getExecuteEdgeIds() {
        return this.executeEdgeIds;
    }

    public synchronized void recordTrigger(Chain.ExecuteNode executeNode) {
        this.currentNode = executeNode.currentNode;
        this.prevNode = executeNode.prevNode;
        this.fromEdgeId = executeNode.fromEdgeId;
        this.triggerCount.incrementAndGet();
        this.triggerEdgeIds.add(executeNode.fromEdgeId);
    }

    public void recordExecute(Chain.ExecuteNode executeNode) {
        this.executeCount.incrementAndGet();
        this.executeEdgeIds.add(executeNode.fromEdgeId);
    }
}

