/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LlmNode
extends BaseNode {
    protected Llm llm;
    protected ChatOptions chatOptions = ChatOptions.DEFAULT;
    protected String userPrompt;
    protected TextPromptTemplate userPromptTemplate;
    protected String systemPrompt;
    protected TextPromptTemplate systemPromptTemplate;
    protected String outType = "text";

    public LlmNode() {
    }

    public LlmNode(Llm llm, String userPrompt) {
        this.llm = llm;
        this.userPrompt = userPrompt;
        this.userPromptTemplate = StringUtil.hasText(userPrompt) ? new TextPromptTemplate(userPrompt) : null;
    }

    public Llm getLlm() {
        return this.llm;
    }

    public void setLlm(Llm llm) {
        this.llm = llm;
    }

    public String getUserPrompt() {
        return this.userPrompt;
    }

    public void setUserPrompt(String userPrompt) {
        this.userPrompt = userPrompt;
        this.userPromptTemplate = StringUtil.hasText(userPrompt) ? new TextPromptTemplate(userPrompt) : null;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        this.systemPromptTemplate = StringUtil.hasText(systemPrompt) ? new TextPromptTemplate(systemPrompt) : null;
    }

    public ChatOptions getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(ChatOptions chatOptions) {
        if (chatOptions == null) {
            chatOptions = ChatOptions.DEFAULT;
        }
        this.chatOptions = chatOptions;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    @Override
    protected Map<String, Object> execute(Chain chain) {
        Map<String, Object> parameters = this.getParameters(chain);
        if (this.userPromptTemplate == null) {
            return Collections.emptyMap();
        }
        Object userPrompt = this.userPromptTemplate.format((Map)parameters);
        if (this.systemPromptTemplate != null) {
            String systemPrompt = this.systemPromptTemplate.formatToString(parameters);
            ((TextPrompt)userPrompt).setSystemMessage(SystemMessage.of(systemPrompt));
        }
        AiMessageResponse response = this.llm.chat((Prompt)userPrompt, this.chatOptions);
        chain.output(this, response);
        if (response.isError()) {
            chain.stopError(response.getErrorMessage());
            return Collections.emptyMap();
        }
        if (this.outType == null || this.outType.equalsIgnoreCase("text") || this.outType.equalsIgnoreCase("markdown")) {
            return Maps.of("output", response.getMessage().getContent());
        }
        if (this.outputDefs != null) {
            JSONObject jsonObject;
            try {
                jsonObject = JSON.parseObject((String)response.getResponse());
            }
            catch (Exception e) {
                chain.stopError("Can not parse json: " + response.getResponse() + " " + e.getMessage());
                return Collections.emptyMap();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Parameter outputDef : this.outputDefs) {
                map.put(outputDef.getName(), jsonObject.get((Object)outputDef.getName()));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return "LlmNode{llm=" + this.llm + ", chatOptions=" + this.chatOptions + ", userPrompt='" + this.userPrompt + '\'' + ", userPromptTemplate=" + this.userPromptTemplate + ", systemPrompt='" + this.systemPrompt + '\'' + ", systemPromptTemplate=" + this.systemPromptTemplate + ", outType='" + this.outType + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + (Object)((Object)this.nodeStatus) + '}';
    }
}

