/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.document.loader;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.document.DocumentLoader;
import com.agentsflex.core.document.DocumentParser;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractDocumentLoader
implements DocumentLoader {
    protected DocumentParser documentParser;

    public AbstractDocumentLoader(DocumentParser documentParser) {
        this.documentParser = documentParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document load() {
        try (InputStream stream = this.loadInputStream();){
            Document document = this.documentParser.parse(stream);
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract InputStream loadInputStream();
}

